/*
   Licensed to the Apache Software Foundation (ASF) under one or more
   contributor license agreements.  See the NOTICE file distributed with
   this work for additional information regarding copyright ownership.
   The ASF licenses this file to You under the Apache License, Version 2.0
   (the "License"); you may not use this file except in compliance with
   the License.  You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
*/
$(document).ready(function() {

    $(".click-title").mouseenter( function(    e){
        e.preventDefault();
        this.style.cursor="pointer";
    });
    $(".click-title").mousedown( function(event){
        event.preventDefault();
    });

    // Ugly code while this script is shared among several pages
    try{
        refreshHitsPerSecond(true);
    } catch(e){}
    try{
        refreshResponseTimeOverTime(true);
    } catch(e){}
    try{
        refreshResponseTimePercentiles();
    } catch(e){}
});


var responseTimePercentilesInfos = {
        data: {"result": {"minY": 5.0, "minX": 0.0, "maxY": 39996.0, "series": [{"data": [[0.0, 5.0], [0.1, 27.0], [0.2, 28.0], [0.3, 28.0], [0.4, 29.0], [0.5, 29.0], [0.6, 29.0], [0.7, 30.0], [0.8, 30.0], [0.9, 30.0], [1.0, 31.0], [1.1, 31.0], [1.2, 31.0], [1.3, 31.0], [1.4, 32.0], [1.5, 32.0], [1.6, 32.0], [1.7, 32.0], [1.8, 33.0], [1.9, 33.0], [2.0, 33.0], [2.1, 33.0], [2.2, 34.0], [2.3, 34.0], [2.4, 34.0], [2.5, 34.0], [2.6, 35.0], [2.7, 35.0], [2.8, 35.0], [2.9, 35.0], [3.0, 36.0], [3.1, 36.0], [3.2, 36.0], [3.3, 36.0], [3.4, 37.0], [3.5, 37.0], [3.6, 37.0], [3.7, 38.0], [3.8, 38.0], [3.9, 38.0], [4.0, 38.0], [4.1, 39.0], [4.2, 39.0], [4.3, 39.0], [4.4, 39.0], [4.5, 40.0], [4.6, 40.0], [4.7, 40.0], [4.8, 40.0], [4.9, 41.0], [5.0, 41.0], [5.1, 41.0], [5.2, 42.0], [5.3, 42.0], [5.4, 42.0], [5.5, 43.0], [5.6, 43.0], [5.7, 43.0], [5.8, 43.0], [5.9, 44.0], [6.0, 44.0], [6.1, 44.0], [6.2, 45.0], [6.3, 45.0], [6.4, 45.0], [6.5, 45.0], [6.6, 46.0], [6.7, 46.0], [6.8, 46.0], [6.9, 47.0], [7.0, 47.0], [7.1, 47.0], [7.2, 48.0], [7.3, 48.0], [7.4, 48.0], [7.5, 49.0], [7.6, 49.0], [7.7, 49.0], [7.8, 49.0], [7.9, 50.0], [8.0, 50.0], [8.1, 50.0], [8.2, 51.0], [8.3, 51.0], [8.4, 51.0], [8.5, 52.0], [8.6, 52.0], [8.7, 52.0], [8.8, 53.0], [8.9, 53.0], [9.0, 53.0], [9.1, 54.0], [9.2, 54.0], [9.3, 55.0], [9.4, 55.0], [9.5, 55.0], [9.6, 56.0], [9.7, 56.0], [9.8, 57.0], [9.9, 57.0], [10.0, 58.0], [10.1, 58.0], [10.2, 59.0], [10.3, 59.0], [10.4, 60.0], [10.5, 60.0], [10.6, 61.0], [10.7, 62.0], [10.8, 62.0], [10.9, 63.0], [11.0, 63.0], [11.1, 64.0], [11.2, 64.0], [11.3, 65.0], [11.4, 66.0], [11.5, 67.0], [11.6, 67.0], [11.7, 68.0], [11.8, 69.0], [11.9, 70.0], [12.0, 71.0], [12.1, 71.0], [12.2, 72.0], [12.3, 73.0], [12.4, 74.0], [12.5, 75.0], [12.6, 75.0], [12.7, 76.0], [12.8, 77.0], [12.9, 79.0], [13.0, 79.0], [13.1, 80.0], [13.2, 82.0], [13.3, 83.0], [13.4, 84.0], [13.5, 85.0], [13.6, 86.0], [13.7, 87.0], [13.8, 88.0], [13.9, 89.0], [14.0, 90.0], [14.1, 91.0], [14.2, 92.0], [14.3, 93.0], [14.4, 95.0], [14.5, 97.0], [14.6, 98.0], [14.7, 100.0], [14.8, 101.0], [14.9, 102.0], [15.0, 104.0], [15.1, 105.0], [15.2, 107.0], [15.3, 108.0], [15.4, 110.0], [15.5, 111.0], [15.6, 113.0], [15.7, 116.0], [15.8, 118.0], [15.9, 120.0], [16.0, 123.0], [16.1, 126.0], [16.2, 129.0], [16.3, 132.0], [16.4, 134.0], [16.5, 137.0], [16.6, 140.0], [16.7, 144.0], [16.8, 148.0], [16.9, 151.0], [17.0, 155.0], [17.1, 157.0], [17.2, 161.0], [17.3, 165.0], [17.4, 168.0], [17.5, 172.0], [17.6, 175.0], [17.7, 179.0], [17.8, 183.0], [17.9, 186.0], [18.0, 189.0], [18.1, 192.0], [18.2, 195.0], [18.3, 197.0], [18.4, 200.0], [18.5, 202.0], [18.6, 205.0], [18.7, 209.0], [18.8, 212.0], [18.9, 215.0], [19.0, 219.0], [19.1, 225.0], [19.2, 229.0], [19.3, 234.0], [19.4, 240.0], [19.5, 244.0], [19.6, 250.0], [19.7, 254.0], [19.8, 259.0], [19.9, 263.0], [20.0, 268.0], [20.1, 271.0], [20.2, 275.0], [20.3, 280.0], [20.4, 284.0], [20.5, 288.0], [20.6, 292.0], [20.7, 296.0], [20.8, 300.0], [20.9, 304.0], [21.0, 308.0], [21.1, 311.0], [21.2, 316.0], [21.3, 320.0], [21.4, 325.0], [21.5, 329.0], [21.6, 334.0], [21.7, 340.0], [21.8, 344.0], [21.9, 350.0], [22.0, 355.0], [22.1, 360.0], [22.2, 365.0], [22.3, 368.0], [22.4, 371.0], [22.5, 375.0], [22.6, 380.0], [22.7, 384.0], [22.8, 387.0], [22.9, 392.0], [23.0, 397.0], [23.1, 401.0], [23.2, 406.0], [23.3, 411.0], [23.4, 416.0], [23.5, 420.0], [23.6, 424.0], [23.7, 430.0], [23.8, 436.0], [23.9, 442.0], [24.0, 447.0], [24.1, 452.0], [24.2, 460.0], [24.3, 466.0], [24.4, 471.0], [24.5, 479.0], [24.6, 483.0], [24.7, 488.0], [24.8, 492.0], [24.9, 498.0], [25.0, 503.0], [25.1, 507.0], [25.2, 514.0], [25.3, 519.0], [25.4, 526.0], [25.5, 530.0], [25.6, 536.0], [25.7, 541.0], [25.8, 545.0], [25.9, 553.0], [26.0, 562.0], [26.1, 568.0], [26.2, 573.0], [26.3, 579.0], [26.4, 587.0], [26.5, 592.0], [26.6, 597.0], [26.7, 601.0], [26.8, 605.0], [26.9, 609.0], [27.0, 615.0], [27.1, 620.0], [27.2, 625.0], [27.3, 631.0], [27.4, 639.0], [27.5, 646.0], [27.6, 651.0], [27.7, 661.0], [27.8, 667.0], [27.9, 676.0], [28.0, 681.0], [28.1, 686.0], [28.2, 692.0], [28.3, 697.0], [28.4, 704.0], [28.5, 711.0], [28.6, 716.0], [28.7, 724.0], [28.8, 731.0], [28.9, 738.0], [29.0, 746.0], [29.1, 756.0], [29.2, 765.0], [29.3, 770.0], [29.4, 777.0], [29.5, 787.0], [29.6, 793.0], [29.7, 800.0], [29.8, 807.0], [29.9, 814.0], [30.0, 822.0], [30.1, 831.0], [30.2, 840.0], [30.3, 848.0], [30.4, 856.0], [30.5, 864.0], [30.6, 871.0], [30.7, 877.0], [30.8, 884.0], [30.9, 892.0], [31.0, 901.0], [31.1, 911.0], [31.2, 920.0], [31.3, 930.0], [31.4, 941.0], [31.5, 952.0], [31.6, 958.0], [31.7, 970.0], [31.8, 979.0], [31.9, 990.0], [32.0, 999.0], [32.1, 1007.0], [32.2, 1015.0], [32.3, 1026.0], [32.4, 1036.0], [32.5, 1047.0], [32.6, 1057.0], [32.7, 1070.0], [32.8, 1079.0], [32.9, 1090.0], [33.0, 1102.0], [33.1, 1113.0], [33.2, 1125.0], [33.3, 1141.0], [33.4, 1153.0], [33.5, 1169.0], [33.6, 1183.0], [33.7, 1196.0], [33.8, 1206.0], [33.9, 1215.0], [34.0, 1226.0], [34.1, 1244.0], [34.2, 1259.0], [34.3, 1276.0], [34.4, 1287.0], [34.5, 1299.0], [34.6, 1311.0], [34.7, 1324.0], [34.8, 1344.0], [34.9, 1357.0], [35.0, 1375.0], [35.1, 1392.0], [35.2, 1404.0], [35.3, 1422.0], [35.4, 1436.0], [35.5, 1452.0], [35.6, 1472.0], [35.7, 1490.0], [35.8, 1503.0], [35.9, 1516.0], [36.0, 1539.0], [36.1, 1558.0], [36.2, 1576.0], [36.3, 1591.0], [36.4, 1606.0], [36.5, 1619.0], [36.6, 1632.0], [36.7, 1647.0], [36.8, 1669.0], [36.9, 1682.0], [37.0, 1697.0], [37.1, 1710.0], [37.2, 1732.0], [37.3, 1760.0], [37.4, 1781.0], [37.5, 1798.0], [37.6, 1820.0], [37.7, 1840.0], [37.8, 1863.0], [37.9, 1887.0], [38.0, 1915.0], [38.1, 1928.0], [38.2, 1947.0], [38.3, 1969.0], [38.4, 1990.0], [38.5, 2010.0], [38.6, 2028.0], [38.7, 2051.0], [38.8, 2076.0], [38.9, 2090.0], [39.0, 2111.0], [39.1, 2135.0], [39.2, 2156.0], [39.3, 2169.0], [39.4, 2192.0], [39.5, 2211.0], [39.6, 2226.0], [39.7, 2246.0], [39.8, 2266.0], [39.9, 2290.0], [40.0, 2309.0], [40.1, 2326.0], [40.2, 2352.0], [40.3, 2375.0], [40.4, 2391.0], [40.5, 2404.0], [40.6, 2425.0], [40.7, 2449.0], [40.8, 2470.0], [40.9, 2485.0], [41.0, 2509.0], [41.1, 2531.0], [41.2, 2559.0], [41.3, 2577.0], [41.4, 2603.0], [41.5, 2624.0], [41.6, 2648.0], [41.7, 2679.0], [41.8, 2708.0], [41.9, 2740.0], [42.0, 2767.0], [42.1, 2780.0], [42.2, 2800.0], [42.3, 2821.0], [42.4, 2844.0], [42.5, 2874.0], [42.6, 2896.0], [42.7, 2915.0], [42.8, 2943.0], [42.9, 2970.0], [43.0, 2985.0], [43.1, 3012.0], [43.2, 3037.0], [43.3, 3063.0], [43.4, 3094.0], [43.5, 3116.0], [43.6, 3144.0], [43.7, 3176.0], [43.8, 3202.0], [43.9, 3226.0], [44.0, 3256.0], [44.1, 3285.0], [44.2, 3310.0], [44.3, 3343.0], [44.4, 3365.0], [44.5, 3388.0], [44.6, 3409.0], [44.7, 3435.0], [44.8, 3475.0], [44.9, 3495.0], [45.0, 3517.0], [45.1, 3543.0], [45.2, 3581.0], [45.3, 3623.0], [45.4, 3671.0], [45.5, 3705.0], [45.6, 3739.0], [45.7, 3769.0], [45.8, 3802.0], [45.9, 3834.0], [46.0, 3868.0], [46.1, 3911.0], [46.2, 3948.0], [46.3, 3978.0], [46.4, 4005.0], [46.5, 4043.0], [46.6, 4086.0], [46.7, 4122.0], [46.8, 4163.0], [46.9, 4194.0], [47.0, 4222.0], [47.1, 4260.0], [47.2, 4289.0], [47.3, 4317.0], [47.4, 4365.0], [47.5, 4396.0], [47.6, 4427.0], [47.7, 4460.0], [47.8, 4491.0], [47.9, 4524.0], [48.0, 4558.0], [48.1, 4593.0], [48.2, 4616.0], [48.3, 4648.0], [48.4, 4683.0], [48.5, 4727.0], [48.6, 4770.0], [48.7, 4803.0], [48.8, 4828.0], [48.9, 4864.0], [49.0, 4907.0], [49.1, 4942.0], [49.2, 4975.0], [49.3, 5009.0], [49.4, 5039.0], [49.5, 5078.0], [49.6, 5108.0], [49.7, 5135.0], [49.8, 5179.0], [49.9, 5208.0], [50.0, 5253.0], [50.1, 5288.0], [50.2, 5328.0], [50.3, 5363.0], [50.4, 5392.0], [50.5, 5421.0], [50.6, 5458.0], [50.7, 5494.0], [50.8, 5516.0], [50.9, 5551.0], [51.0, 5590.0], [51.1, 5621.0], [51.2, 5656.0], [51.3, 5687.0], [51.4, 5725.0], [51.5, 5768.0], [51.6, 5796.0], [51.7, 5830.0], [51.8, 5860.0], [51.9, 5900.0], [52.0, 5942.0], [52.1, 5983.0], [52.2, 6034.0], [52.3, 6072.0], [52.4, 6097.0], [52.5, 6125.0], [52.6, 6159.0], [52.7, 6196.0], [52.8, 6227.0], [52.9, 6269.0], [53.0, 6315.0], [53.1, 6345.0], [53.2, 6391.0], [53.3, 6420.0], [53.4, 6452.0], [53.5, 6487.0], [53.6, 6521.0], [53.7, 6584.0], [53.8, 6624.0], [53.9, 6664.0], [54.0, 6696.0], [54.1, 6749.0], [54.2, 6788.0], [54.3, 6812.0], [54.4, 6843.0], [54.5, 6887.0], [54.6, 6929.0], [54.7, 6973.0], [54.8, 7013.0], [54.9, 7056.0], [55.0, 7092.0], [55.1, 7133.0], [55.2, 7173.0], [55.3, 7214.0], [55.4, 7258.0], [55.5, 7293.0], [55.6, 7332.0], [55.7, 7372.0], [55.8, 7415.0], [55.9, 7451.0], [56.0, 7494.0], [56.1, 7541.0], [56.2, 7583.0], [56.3, 7617.0], [56.4, 7663.0], [56.5, 7697.0], [56.6, 7748.0], [56.7, 7799.0], [56.8, 7850.0], [56.9, 7891.0], [57.0, 7931.0], [57.1, 7960.0], [57.2, 8007.0], [57.3, 8049.0], [57.4, 8087.0], [57.5, 8114.0], [57.6, 8153.0], [57.7, 8191.0], [57.8, 8215.0], [57.9, 8265.0], [58.0, 8318.0], [58.1, 8365.0], [58.2, 8404.0], [58.3, 8444.0], [58.4, 8475.0], [58.5, 8515.0], [58.6, 8540.0], [58.7, 8583.0], [58.8, 8613.0], [58.9, 8652.0], [59.0, 8679.0], [59.1, 8708.0], [59.2, 8744.0], [59.3, 8771.0], [59.4, 8802.0], [59.5, 8832.0], [59.6, 8864.0], [59.7, 8908.0], [59.8, 8935.0], [59.9, 8964.0], [60.0, 8994.0], [60.1, 9023.0], [60.2, 9055.0], [60.3, 9086.0], [60.4, 9108.0], [60.5, 9143.0], [60.6, 9163.0], [60.7, 9193.0], [60.8, 9218.0], [60.9, 9241.0], [61.0, 9272.0], [61.1, 9296.0], [61.2, 9328.0], [61.3, 9352.0], [61.4, 9386.0], [61.5, 9409.0], [61.6, 9438.0], [61.7, 9459.0], [61.8, 9479.0], [61.9, 9511.0], [62.0, 9549.0], [62.1, 9583.0], [62.2, 9606.0], [62.3, 9640.0], [62.4, 9672.0], [62.5, 9705.0], [62.6, 9724.0], [62.7, 9754.0], [62.8, 9787.0], [62.9, 9814.0], [63.0, 9835.0], [63.1, 9868.0], [63.2, 9902.0], [63.3, 9928.0], [63.4, 9972.0], [63.5, 10005.0], [63.6, 10042.0], [63.7, 10077.0], [63.8, 10117.0], [63.9, 10148.0], [64.0, 10180.0], [64.1, 10214.0], [64.2, 10245.0], [64.3, 10274.0], [64.4, 10306.0], [64.5, 10348.0], [64.6, 10380.0], [64.7, 10413.0], [64.8, 10447.0], [64.9, 10487.0], [65.0, 10531.0], [65.1, 10567.0], [65.2, 10612.0], [65.3, 10653.0], [65.4, 10707.0], [65.5, 10756.0], [65.6, 10804.0], [65.7, 10854.0], [65.8, 10912.0], [65.9, 10939.0], [66.0, 10983.0], [66.1, 11023.0], [66.2, 11068.0], [66.3, 11105.0], [66.4, 11153.0], [66.5, 11198.0], [66.6, 11237.0], [66.7, 11283.0], [66.8, 11327.0], [66.9, 11364.0], [67.0, 11410.0], [67.1, 11448.0], [67.2, 11495.0], [67.3, 11547.0], [67.4, 11578.0], [67.5, 11609.0], [67.6, 11651.0], [67.7, 11701.0], [67.8, 11757.0], [67.9, 11792.0], [68.0, 11828.0], [68.1, 11871.0], [68.2, 11919.0], [68.3, 11976.0], [68.4, 12022.0], [68.5, 12063.0], [68.6, 12116.0], [68.7, 12154.0], [68.8, 12196.0], [68.9, 12228.0], [69.0, 12272.0], [69.1, 12314.0], [69.2, 12354.0], [69.3, 12379.0], [69.4, 12412.0], [69.5, 12456.0], [69.6, 12483.0], [69.7, 12511.0], [69.8, 12546.0], [69.9, 12572.0], [70.0, 12611.0], [70.1, 12648.0], [70.2, 12684.0], [70.3, 12709.0], [70.4, 12740.0], [70.5, 12776.0], [70.6, 12814.0], [70.7, 12848.0], [70.8, 12876.0], [70.9, 12912.0], [71.0, 12949.0], [71.1, 12989.0], [71.2, 13017.0], [71.3, 13050.0], [71.4, 13091.0], [71.5, 13143.0], [71.6, 13171.0], [71.7, 13202.0], [71.8, 13238.0], [71.9, 13262.0], [72.0, 13288.0], [72.1, 13315.0], [72.2, 13356.0], [72.3, 13398.0], [72.4, 13421.0], [72.5, 13453.0], [72.6, 13492.0], [72.7, 13526.0], [72.8, 13554.0], [72.9, 13580.0], [73.0, 13606.0], [73.1, 13627.0], [73.2, 13656.0], [73.3, 13698.0], [73.4, 13721.0], [73.5, 13741.0], [73.6, 13766.0], [73.7, 13786.0], [73.8, 13807.0], [73.9, 13836.0], [74.0, 13870.0], [74.1, 13899.0], [74.2, 13919.0], [74.3, 13950.0], [74.4, 13976.0], [74.5, 13998.0], [74.6, 14021.0], [74.7, 14051.0], [74.8, 14075.0], [74.9, 14097.0], [75.0, 14118.0], [75.1, 14143.0], [75.2, 14161.0], [75.3, 14186.0], [75.4, 14203.0], [75.5, 14221.0], [75.6, 14244.0], [75.7, 14269.0], [75.8, 14288.0], [75.9, 14309.0], [76.0, 14335.0], [76.1, 14364.0], [76.2, 14386.0], [76.3, 14407.0], [76.4, 14430.0], [76.5, 14459.0], [76.6, 14484.0], [76.7, 14507.0], [76.8, 14530.0], [76.9, 14552.0], [77.0, 14570.0], [77.1, 14595.0], [77.2, 14611.0], [77.3, 14636.0], [77.4, 14652.0], [77.5, 14675.0], [77.6, 14691.0], [77.7, 14711.0], [77.8, 14731.0], [77.9, 14746.0], [78.0, 14765.0], [78.1, 14786.0], [78.2, 14809.0], [78.3, 14829.0], [78.4, 14848.0], [78.5, 14865.0], [78.6, 14880.0], [78.7, 14901.0], [78.8, 14918.0], [78.9, 14936.0], [79.0, 14950.0], [79.1, 14964.0], [79.2, 14985.0], [79.3, 15001.0], [79.4, 15019.0], [79.5, 15034.0], [79.6, 15054.0], [79.7, 15073.0], [79.8, 15090.0], [79.9, 15108.0], [80.0, 15125.0], [80.1, 15140.0], [80.2, 15153.0], [80.3, 15170.0], [80.4, 15185.0], [80.5, 15197.0], [80.6, 15211.0], [80.7, 15226.0], [80.8, 15243.0], [80.9, 15262.0], [81.0, 15277.0], [81.1, 15289.0], [81.2, 15305.0], [81.3, 15317.0], [81.4, 15333.0], [81.5, 15347.0], [81.6, 15364.0], [81.7, 15386.0], [81.8, 15399.0], [81.9, 15417.0], [82.0, 15438.0], [82.1, 15451.0], [82.2, 15466.0], [82.3, 15478.0], [82.4, 15496.0], [82.5, 15518.0], [82.6, 15531.0], [82.7, 15547.0], [82.8, 15563.0], [82.9, 15578.0], [83.0, 15602.0], [83.1, 15618.0], [83.2, 15635.0], [83.3, 15650.0], [83.4, 15664.0], [83.5, 15676.0], [83.6, 15697.0], [83.7, 15715.0], [83.8, 15730.0], [83.9, 15751.0], [84.0, 15770.0], [84.1, 15781.0], [84.2, 15803.0], [84.3, 15822.0], [84.4, 15837.0], [84.5, 15856.0], [84.6, 15873.0], [84.7, 15888.0], [84.8, 15907.0], [84.9, 15918.0], [85.0, 15931.0], [85.1, 15948.0], [85.2, 15965.0], [85.3, 15981.0], [85.4, 15998.0], [85.5, 16017.0], [85.6, 16033.0], [85.7, 16053.0], [85.8, 16070.0], [85.9, 16091.0], [86.0, 16108.0], [86.1, 16124.0], [86.2, 16140.0], [86.3, 16164.0], [86.4, 16180.0], [86.5, 16199.0], [86.6, 16215.0], [86.7, 16242.0], [86.8, 16267.0], [86.9, 16282.0], [87.0, 16303.0], [87.1, 16326.0], [87.2, 16339.0], [87.3, 16361.0], [87.4, 16390.0], [87.5, 16414.0], [87.6, 16431.0], [87.7, 16450.0], [87.8, 16468.0], [87.9, 16485.0], [88.0, 16507.0], [88.1, 16524.0], [88.2, 16546.0], [88.3, 16570.0], [88.4, 16588.0], [88.5, 16610.0], [88.6, 16637.0], [88.7, 16664.0], [88.8, 16693.0], [88.9, 16718.0], [89.0, 16745.0], [89.1, 16776.0], [89.2, 16806.0], [89.3, 16831.0], [89.4, 16858.0], [89.5, 16878.0], [89.6, 16907.0], [89.7, 16937.0], [89.8, 16972.0], [89.9, 17000.0], [90.0, 17029.0], [90.1, 17060.0], [90.2, 17094.0], [90.3, 17119.0], [90.4, 17150.0], [90.5, 17187.0], [90.6, 17215.0], [90.7, 17261.0], [90.8, 17288.0], [90.9, 17331.0], [91.0, 17373.0], [91.1, 17413.0], [91.2, 17452.0], [91.3, 17492.0], [91.4, 17540.0], [91.5, 17607.0], [91.6, 17673.0], [91.7, 17738.0], [91.8, 17806.0], [91.9, 17846.0], [92.0, 17928.0], [92.1, 17988.0], [92.2, 18069.0], [92.3, 18132.0], [92.4, 18206.0], [92.5, 18312.0], [92.6, 18406.0], [92.7, 18474.0], [92.8, 18593.0], [92.9, 18696.0], [93.0, 18829.0], [93.1, 18992.0], [93.2, 19129.0], [93.3, 19343.0], [93.4, 19476.0], [93.5, 19687.0], [93.6, 19902.0], [93.7, 20161.0], [93.8, 20373.0], [93.9, 20600.0], [94.0, 20855.0], [94.1, 21145.0], [94.2, 21444.0], [94.3, 21645.0], [94.4, 21998.0], [94.5, 22330.0], [94.6, 22702.0], [94.7, 23015.0], [94.8, 23375.0], [94.9, 23662.0], [95.0, 23981.0], [95.1, 24446.0], [95.2, 24766.0], [95.3, 25185.0], [95.4, 25548.0], [95.5, 25891.0], [95.6, 26194.0], [95.7, 26488.0], [95.8, 26899.0], [95.9, 27288.0], [96.0, 27662.0], [96.1, 28037.0], [96.2, 28261.0], [96.3, 28494.0], [96.4, 28720.0], [96.5, 28926.0], [96.6, 29100.0], [96.7, 29238.0], [96.8, 29375.0], [96.9, 29519.0], [97.0, 29642.0], [97.1, 29798.0], [97.2, 29902.0], [97.3, 30015.0], [97.4, 30126.0], [97.5, 30275.0], [97.6, 30395.0], [97.7, 30572.0], [97.8, 30692.0], [97.9, 30804.0], [98.0, 30909.0], [98.1, 31029.0], [98.2, 31138.0], [98.3, 31225.0], [98.4, 31323.0], [98.5, 31490.0], [98.6, 31595.0], [98.7, 31692.0], [98.8, 31772.0], [98.9, 31932.0], [99.0, 32051.0], [99.1, 32184.0], [99.2, 32308.0], [99.3, 32422.0], [99.4, 32583.0], [99.5, 32712.0], [99.6, 32881.0], [99.7, 33119.0], [99.8, 33355.0], [99.9, 33943.0], [100.0, 39996.0]], "isOverall": false, "label": "HTTP Request", "isController": false}], "supportsControllersDiscrimination": true, "maxX": 100.0, "title": "Response Time Percentiles"}},
        getOptions: function() {
            return {
                series: {
                    points: { show: false }
                },
                legend: {
                    noColumns: 2,
                    show: true,
                    container: '#legendResponseTimePercentiles'
                },
                xaxis: {
                    tickDecimals: 1,
                    axisLabel: "Percentiles",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                yaxis: {
                    axisLabel: "Percentile value in ms",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20
                },
                grid: {
                    hoverable: true // IMPORTANT! this is needed for tooltip to
                                    // work
                },
                tooltip: true,
                tooltipOpts: {
                    content: "%s : %x.2 percentile was %y ms"
                },
                selection: { mode: "xy" },
            };
        },
        createGraph: function() {
            var data = this.data;
            var dataset = prepareData(data.result.series, $("#choicesResponseTimePercentiles"));
            var options = this.getOptions();
            prepareOptions(options, data);
            $.plot($("#flotResponseTimesPercentiles"), dataset, options);
            // setup overview
            $.plot($("#overviewResponseTimesPercentiles"), dataset, prepareOverviewOptions(options));
        }
};

/**
 * @param elementId Id of element where we display message
 */
function setEmptyGraph(elementId) {
    $(function() {
        $(elementId).text("No graph series with filter="+seriesFilter);
    });
}

// Response times percentiles
function refreshResponseTimePercentiles() {
    var infos = responseTimePercentilesInfos;
    prepareSeries(infos.data);
    if(infos.data.result.series.length == 0) {
        setEmptyGraph("#bodyResponseTimePercentiles");
        return;
    }
    if (isGraph($("#flotResponseTimesPercentiles"))){
        infos.createGraph();
    } else {
        var choiceContainer = $("#choicesResponseTimePercentiles");
        createLegend(choiceContainer, infos);
        infos.createGraph();
        setGraphZoomable("#flotResponseTimesPercentiles", "#overviewResponseTimesPercentiles");
        $('#bodyResponseTimePercentiles .legendColorBox > div').each(function(i){
            $(this).clone().prependTo(choiceContainer.find("li").eq(i));
        });
    }
}

var responseTimeDistributionInfos = {
        data: {"result": {"minY": 1.0, "minX": 0.0, "maxY": 4334.0, "series": [{"data": [[0.0, 4334.0], [100.0, 1091.0], [33300.0, 13.0], [32900.0, 11.0], [34100.0, 2.0], [33700.0, 3.0], [34900.0, 1.0], [37300.0, 1.0], [37700.0, 1.0], [200.0, 707.0], [300.0, 671.0], [400.0, 549.0], [500.0, 518.0], [600.0, 492.0], [700.0, 395.0], [800.0, 385.0], [900.0, 303.0], [1000.0, 289.0], [1100.0, 218.0], [1200.0, 231.0], [1300.0, 193.0], [1400.0, 181.0], [1500.0, 168.0], [1600.0, 199.0], [1700.0, 141.0], [1800.0, 134.0], [1900.0, 145.0], [2000.0, 146.0], [2100.0, 143.0], [2300.0, 153.0], [2200.0, 150.0], [2400.0, 147.0], [2500.0, 129.0], [2600.0, 112.0], [2700.0, 127.0], [2800.0, 122.0], [2900.0, 133.0], [3000.0, 107.0], [3100.0, 107.0], [3200.0, 106.0], [3300.0, 124.0], [3400.0, 104.0], [3500.0, 95.0], [3600.0, 70.0], [3700.0, 88.0], [3800.0, 85.0], [3900.0, 90.0], [4000.0, 81.0], [4100.0, 80.0], [4200.0, 100.0], [4300.0, 75.0], [4600.0, 93.0], [4400.0, 96.0], [4500.0, 85.0], [4800.0, 85.0], [4700.0, 71.0], [5000.0, 88.0], [5100.0, 89.0], [4900.0, 88.0], [5200.0, 77.0], [5300.0, 90.0], [5500.0, 88.0], [5600.0, 90.0], [5400.0, 89.0], [5700.0, 84.0], [5800.0, 81.0], [5900.0, 70.0], [6100.0, 87.0], [6000.0, 83.0], [6300.0, 74.0], [6200.0, 75.0], [6400.0, 97.0], [6500.0, 59.0], [6600.0, 79.0], [6800.0, 86.0], [6700.0, 70.0], [6900.0, 67.0], [7000.0, 75.0], [7100.0, 73.0], [7300.0, 77.0], [7400.0, 77.0], [7200.0, 69.0], [7600.0, 79.0], [7500.0, 62.0], [7800.0, 63.0], [7700.0, 59.0], [7900.0, 81.0], [8100.0, 84.0], [8000.0, 75.0], [8400.0, 79.0], [8200.0, 70.0], [8300.0, 62.0], [8700.0, 95.0], [8500.0, 90.0], [8600.0, 95.0], [8800.0, 85.0], [8900.0, 99.0], [9100.0, 110.0], [9200.0, 111.0], [9000.0, 101.0], [9300.0, 102.0], [9400.0, 122.0], [9600.0, 90.0], [9500.0, 92.0], [9700.0, 107.0], [10100.0, 83.0], [10000.0, 80.0], [10200.0, 97.0], [9800.0, 103.0], [9900.0, 87.0], [10400.0, 89.0], [10700.0, 62.0], [10300.0, 78.0], [10500.0, 69.0], [10600.0, 63.0], [11000.0, 73.0], [11200.0, 66.0], [11100.0, 67.0], [10900.0, 77.0], [10800.0, 54.0], [11700.0, 69.0], [11500.0, 77.0], [11400.0, 66.0], [11300.0, 73.0], [11600.0, 65.0], [11900.0, 50.0], [12100.0, 71.0], [12000.0, 69.0], [12200.0, 77.0], [11800.0, 72.0], [12700.0, 90.0], [12500.0, 97.0], [12300.0, 87.0], [12600.0, 84.0], [12400.0, 83.0], [13200.0, 102.0], [12900.0, 79.0], [12800.0, 91.0], [13300.0, 77.0], [13000.0, 79.0], [13100.0, 84.0], [13600.0, 99.0], [13400.0, 94.0], [13700.0, 136.0], [13500.0, 104.0], [13800.0, 99.0], [14000.0, 119.0], [13900.0, 119.0], [14200.0, 136.0], [14300.0, 118.0], [14100.0, 140.0], [14400.0, 127.0], [14800.0, 159.0], [14700.0, 154.0], [14500.0, 133.0], [14600.0, 147.0], [15200.0, 194.0], [15100.0, 192.0], [14900.0, 179.0], [15000.0, 167.0], [15300.0, 187.0], [15400.0, 185.0], [15500.0, 165.0], [15600.0, 186.0], [15800.0, 169.0], [15700.0, 165.0], [15900.0, 194.0], [16300.0, 139.0], [16000.0, 158.0], [16100.0, 164.0], [16200.0, 139.0], [17400.0, 75.0], [16400.0, 155.0], [17000.0, 95.0], [17200.0, 82.0], [16800.0, 115.0], [16600.0, 113.0], [17600.0, 47.0], [17800.0, 54.0], [18400.0, 39.0], [18200.0, 26.0], [18000.0, 39.0], [19400.0, 14.0], [18600.0, 28.0], [19000.0, 20.0], [19200.0, 19.0], [18800.0, 29.0], [20200.0, 17.0], [20400.0, 15.0], [19800.0, 12.0], [19600.0, 12.0], [20000.0, 10.0], [20600.0, 13.0], [21000.0, 10.0], [20800.0, 10.0], [21200.0, 5.0], [21400.0, 9.0], [21600.0, 13.0], [22200.0, 8.0], [22000.0, 9.0], [21800.0, 8.0], [22400.0, 9.0], [23000.0, 12.0], [23200.0, 7.0], [22800.0, 6.0], [23400.0, 13.0], [22600.0, 3.0], [23800.0, 10.0], [24000.0, 7.0], [23600.0, 11.0], [24400.0, 6.0], [24200.0, 7.0], [24600.0, 9.0], [24800.0, 10.0], [25200.0, 4.0], [25400.0, 8.0], [25000.0, 2.0], [25600.0, 12.0], [26200.0, 16.0], [26000.0, 9.0], [26400.0, 8.0], [26600.0, 8.0], [25800.0, 8.0], [27200.0, 8.0], [26800.0, 3.0], [27600.0, 11.0], [27000.0, 9.0], [27400.0, 6.0], [27800.0, 11.0], [28000.0, 12.0], [28600.0, 16.0], [28400.0, 15.0], [28200.0, 12.0], [29000.0, 16.0], [28800.0, 16.0], [29600.0, 21.0], [29400.0, 19.0], [29200.0, 19.0], [30000.0, 21.0], [30200.0, 22.0], [30600.0, 24.0], [30400.0, 18.0], [29800.0, 27.0], [31600.0, 31.0], [31400.0, 22.0], [30800.0, 25.0], [31000.0, 25.0], [31200.0, 31.0], [31800.0, 20.0], [32200.0, 22.0], [32400.0, 19.0], [32000.0, 23.0], [32600.0, 20.0], [33600.0, 5.0], [32800.0, 11.0], [34800.0, 2.0], [33200.0, 13.0], [34000.0, 2.0], [34400.0, 1.0], [35600.0, 3.0], [35200.0, 1.0], [36800.0, 1.0], [37600.0, 1.0], [37200.0, 1.0], [33100.0, 9.0], [33900.0, 5.0], [33500.0, 2.0], [34300.0, 2.0], [35100.0, 3.0], [39900.0, 1.0], [16500.0, 139.0], [16900.0, 96.0], [17100.0, 94.0], [16700.0, 106.0], [17300.0, 71.0], [17500.0, 53.0], [18300.0, 35.0], [17700.0, 38.0], [18100.0, 40.0], [17900.0, 47.0], [18500.0, 24.0], [19300.0, 20.0], [18700.0, 16.0], [19100.0, 15.0], [18900.0, 17.0], [19500.0, 16.0], [19700.0, 15.0], [20300.0, 9.0], [19900.0, 15.0], [20100.0, 11.0], [20900.0, 10.0], [21300.0, 11.0], [20500.0, 12.0], [21500.0, 17.0], [20700.0, 11.0], [21100.0, 16.0], [21700.0, 7.0], [22500.0, 12.0], [22300.0, 9.0], [22100.0, 8.0], [21900.0, 8.0], [22900.0, 12.0], [22700.0, 9.0], [23300.0, 9.0], [23100.0, 7.0], [23500.0, 8.0], [23900.0, 12.0], [24100.0, 7.0], [24500.0, 9.0], [23700.0, 6.0], [24300.0, 4.0], [24700.0, 10.0], [25100.0, 5.0], [25300.0, 8.0], [24900.0, 11.0], [25500.0, 10.0], [26500.0, 7.0], [25900.0, 12.0], [26100.0, 8.0], [25700.0, 9.0], [26300.0, 5.0], [27300.0, 7.0], [26700.0, 11.0], [27100.0, 7.0], [27500.0, 6.0], [26900.0, 8.0], [28300.0, 10.0], [27900.0, 8.0], [28100.0, 15.0], [27700.0, 4.0], [28500.0, 9.0], [28900.0, 18.0], [29500.0, 22.0], [29100.0, 23.0], [29300.0, 22.0], [28700.0, 11.0], [29700.0, 23.0], [30300.0, 22.0], [29900.0, 29.0], [30500.0, 19.0], [30700.0, 26.0], [30100.0, 27.0], [31100.0, 33.0], [31300.0, 23.0], [31700.0, 31.0], [31500.0, 24.0], [30900.0, 25.0], [32300.0, 27.0], [32700.0, 22.0], [32500.0, 23.0], [31900.0, 24.0], [32100.0, 21.0], [33800.0, 4.0], [33400.0, 11.0], [33000.0, 17.0], [34600.0, 1.0], [35000.0, 1.0]], "isOverall": false, "label": "HTTP Request", "isController": false}], "supportsControllersDiscrimination": true, "granularity": 100, "maxX": 39900.0, "title": "Response Time Distribution"}},
        getOptions: function() {
            var granularity = this.data.result.granularity;
            return {
                legend: {
                    noColumns: 2,
                    show: true,
                    container: '#legendResponseTimeDistribution'
                },
                xaxis:{
                    axisLabel: "Response times in ms",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                yaxis: {
                    axisLabel: "Number of responses",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                bars : {
                    show: true,
                    barWidth: this.data.result.granularity
                },
                grid: {
                    hoverable: true // IMPORTANT! this is needed for tooltip to
                                    // work
                },
                tooltip: true,
                tooltipOpts: {
                    content: function(label, xval, yval, flotItem){
                        return yval + " responses for " + label + " were between " + xval + " and " + (xval + granularity) + " ms";
                    }
                }
            };
        },
        createGraph: function() {
            var data = this.data;
            var options = this.getOptions();
            prepareOptions(options, data);
            $.plot($("#flotResponseTimeDistribution"), prepareData(data.result.series, $("#choicesResponseTimeDistribution")), options);
        }

};

// Response time distribution
function refreshResponseTimeDistribution() {
    var infos = responseTimeDistributionInfos;
    prepareSeries(infos.data);
    if(infos.data.result.series.length == 0) {
        setEmptyGraph("#bodyResponseTimeDistribution");
        return;
    }
    if (isGraph($("#flotResponseTimeDistribution"))){
        infos.createGraph();
    }else{
        var choiceContainer = $("#choicesResponseTimeDistribution");
        createLegend(choiceContainer, infos);
        infos.createGraph();
        $('#footerResponseTimeDistribution .legendColorBox > div').each(function(i){
            $(this).clone().prependTo(choiceContainer.find("li").eq(i));
        });
    }
};


var syntheticResponseTimeDistributionInfos = {
        data: {"result": {"minY": 13.0, "minX": 0.0, "ticks": [[0, "Requests having \nresponse time <= 500ms"], [1, "Requests having \nresponse time > 500ms and <= 1,500ms"], [2, "Requests having \nresponse time > 1,500ms"], [3, "Requests in error"]], "maxY": 18946.0, "series": [{"data": [[0.0, 7344.0]], "color": "#9ACD32", "isOverall": false, "label": "Requests having \nresponse time <= 500ms", "isController": false}, {"data": [[1.0, 3202.0]], "color": "yellow", "isOverall": false, "label": "Requests having \nresponse time > 500ms and <= 1,500ms", "isController": false}, {"data": [[2.0, 18946.0]], "color": "orange", "isOverall": false, "label": "Requests having \nresponse time > 1,500ms", "isController": false}, {"data": [[3.0, 13.0]], "color": "#FF6347", "isOverall": false, "label": "Requests in error", "isController": false}], "supportsControllersDiscrimination": false, "maxX": 3.0, "title": "Synthetic Response Times Distribution"}},
        getOptions: function() {
            return {
                legend: {
                    noColumns: 2,
                    show: true,
                    container: '#legendSyntheticResponseTimeDistribution'
                },
                xaxis:{
                    axisLabel: "Response times ranges",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                    tickLength:0,
                    min:-0.5,
                    max:3.5
                },
                yaxis: {
                    axisLabel: "Number of responses",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                bars : {
                    show: true,
                    align: "center",
                    barWidth: 0.25,
                    fill:.75
                },
                grid: {
                    hoverable: true // IMPORTANT! this is needed for tooltip to
                                    // work
                },
                tooltip: true,
                tooltipOpts: {
                    content: function(label, xval, yval, flotItem){
                        return yval + " " + label;
                    }
                }
            };
        },
        createGraph: function() {
            var data = this.data;
            var options = this.getOptions();
            prepareOptions(options, data);
            options.xaxis.ticks = data.result.ticks;
            $.plot($("#flotSyntheticResponseTimeDistribution"), prepareData(data.result.series, $("#choicesSyntheticResponseTimeDistribution")), options);
        }

};

// Response time distribution
function refreshSyntheticResponseTimeDistribution() {
    var infos = syntheticResponseTimeDistributionInfos;
    prepareSeries(infos.data, true);
    if (isGraph($("#flotSyntheticResponseTimeDistribution"))){
        infos.createGraph();
    }else{
        var choiceContainer = $("#choicesSyntheticResponseTimeDistribution");
        createLegend(choiceContainer, infos);
        infos.createGraph();
        $('#footerSyntheticResponseTimeDistribution .legendColorBox > div').each(function(i){
            $(this).clone().prependTo(choiceContainer.find("li").eq(i));
        });
    }
};

var activeThreadsOverTimeInfos = {
        data: {"result": {"minY": 517.0131738954186, "minX": 1.6982169E12, "maxY": 885.0959280158625, "series": [{"data": [[1.69821714E12, 885.0959280158625], [1.69821696E12, 778.6840986394541], [1.69821702E12, 697.4624762507941], [1.6982172E12, 517.0131738954186], [1.6982169E12, 622.0011061946899], [1.69821726E12, 880.7783771634091], [1.69821708E12, 518.3323315802633]], "isOverall": false, "label": "jp@gc - Ultimate Thread Group", "isController": false}], "supportsControllersDiscrimination": false, "granularity": 60000, "maxX": 1.69821726E12, "title": "Active Threads Over Time"}},
        getOptions: function() {
            return {
                series: {
                    stack: true,
                    lines: {
                        show: true,
                        fill: true
                    },
                    points: {
                        show: true
                    }
                },
                xaxis: {
                    mode: "time",
                    timeformat: getTimeFormat(this.data.result.granularity),
                    axisLabel: getElapsedTimeLabel(this.data.result.granularity),
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                yaxis: {
                    axisLabel: "Number of active threads",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20
                },
                legend: {
                    noColumns: 6,
                    show: true,
                    container: '#legendActiveThreadsOverTime'
                },
                grid: {
                    hoverable: true // IMPORTANT! this is needed for tooltip to
                                    // work
                },
                selection: {
                    mode: 'xy'
                },
                tooltip: true,
                tooltipOpts: {
                    content: "%s : At %x there were %y active threads"
                }
            };
        },
        createGraph: function() {
            var data = this.data;
            var dataset = prepareData(data.result.series, $("#choicesActiveThreadsOverTime"));
            var options = this.getOptions();
            prepareOptions(options, data);
            $.plot($("#flotActiveThreadsOverTime"), dataset, options);
            // setup overview
            $.plot($("#overviewActiveThreadsOverTime"), dataset, prepareOverviewOptions(options));
        }
};

// Active Threads Over Time
function refreshActiveThreadsOverTime(fixTimestamps) {
    var infos = activeThreadsOverTimeInfos;
    prepareSeries(infos.data);
    if(fixTimestamps) {
        fixTimeStamps(infos.data.result.series, 10800000);
    }
    if(isGraph($("#flotActiveThreadsOverTime"))) {
        infos.createGraph();
    }else{
        var choiceContainer = $("#choicesActiveThreadsOverTime");
        createLegend(choiceContainer, infos);
        infos.createGraph();
        setGraphZoomable("#flotActiveThreadsOverTime", "#overviewActiveThreadsOverTime");
        $('#footerActiveThreadsOverTime .legendColorBox > div').each(function(i){
            $(this).clone().prependTo(choiceContainer.find("li").eq(i));
        });
    }
};

var timeVsThreadsInfos = {
        data: {"result": {"minY": 1324.2, "minX": 1.0, "maxY": 20447.5, "series": [{"data": [[2.0, 12945.333333333334], [3.0, 5958.200000000001], [4.0, 4215.285714285715], [5.0, 7691.333333333332], [6.0, 8243.875], [7.0, 4693.545454545454], [8.0, 4835.400000000001], [9.0, 5372.400000000001], [10.0, 2118.8750000000005], [11.0, 7067.181818181818], [12.0, 2922.625], [13.0, 7600.363636363636], [14.0, 3443.7142857142853], [15.0, 4587.277777777777], [16.0, 4162.9], [17.0, 3527.357142857142], [18.0, 5675.625], [19.0, 2102.357142857143], [20.0, 5723.125], [21.0, 1672.4166666666665], [22.0, 5282.285714285715], [23.0, 3367.3125], [24.0, 2303.0], [25.0, 5005.904761904762], [26.0, 6330.799999999999], [27.0, 2925.857142857143], [28.0, 2367.7], [29.0, 6234.666666666667], [30.0, 4387.076923076923], [31.0, 2737.235294117647], [33.0, 4029.5294117647063], [32.0, 1324.2], [35.0, 3259.6428571428573], [34.0, 2302.5714285714284], [36.0, 5005.285714285714], [37.0, 1403.5263157894738], [38.0, 4228.111111111111], [39.0, 1712.9999999999998], [40.0, 3851.227272727274], [41.0, 1328.6153846153848], [43.0, 3603.5384615384623], [42.0, 5977.142857142856], [44.0, 2289.6666666666665], [45.0, 9205.208333333334], [46.0, 9587.666666666666], [47.0, 3462.75], [49.0, 3273.4444444444443], [48.0, 3804.1249999999995], [50.0, 4095.428571428572], [51.0, 3302.3], [53.0, 4826.692307692308], [52.0, 8698.42857142857], [54.0, 1567.1481481481483], [55.0, 2103.5882352941176], [57.0, 4716.812499999999], [56.0, 3186.3333333333335], [58.0, 1666.25], [59.0, 4061.9], [60.0, 3229.1666666666665], [61.0, 2295.931034482759], [63.0, 2575.0], [62.0, 7360.333333333332], [64.0, 1710.5], [67.0, 4394.333333333333], [66.0, 5630.583333333334], [65.0, 13463.449999999997], [70.0, 6357.599999999999], [71.0, 2094.958333333333], [69.0, 4462.941176470588], [68.0, 3304.625], [73.0, 5052.88888888889], [74.0, 3368.352941176471], [72.0, 2880.6923076923076], [75.0, 2738.0714285714284], [77.0, 3254.263157894738], [79.0, 5178.857142857143], [78.0, 3198.0588235294113], [76.0, 4419.166666666666], [80.0, 4201.666666666666], [83.0, 4428.166666666666], [82.0, 8000.0], [81.0, 1357.6315789473686], [84.0, 3077.608695652174], [87.0, 3614.7058823529414], [86.0, 4084.0833333333335], [85.0, 7068.888888888889], [91.0, 3536.814814814815], [90.0, 6603.937499999999], [88.0, 4894.000000000001], [89.0, 1977.3333333333335], [93.0, 5170.1500000000015], [95.0, 5175.833333333334], [92.0, 2433.1], [94.0, 2822.0645161290317], [96.0, 5139.7692307692305], [97.0, 3539.176470588235], [99.0, 4168.666666666666], [98.0, 4332.260869565217], [100.0, 5794.1], [103.0, 7667.8], [102.0, 3805.3846153846157], [101.0, 3236.6551724137926], [104.0, 2500.2400000000002], [107.0, 2870.8695652173915], [106.0, 7175.357142857143], [105.0, 3032.4], [110.0, 3120.764705882353], [111.0, 3514.6874999999995], [109.0, 9734.363636363638], [108.0, 3918.190476190477], [115.0, 2176.814814814815], [114.0, 5166.473684210527], [113.0, 4204.416666666667], [112.0, 5367.5], [117.0, 3978.699999999999], [119.0, 7120.125], [118.0, 3606.4736842105262], [116.0, 10070.125], [120.0, 6128.545454545455], [123.0, 5615.235294117647], [122.0, 3146.5], [121.0, 5025.105263157894], [124.0, 4196.5625], [127.0, 3475.0555555555557], [126.0, 5431.363636363635], [125.0, 2529.916666666666], [130.0, 4031.4210526315787], [134.0, 3388.130434782609], [135.0, 3431.789473684211], [133.0, 7495.583333333334], [131.0, 3125.92], [129.0, 4997.846153846154], [128.0, 5194.761904761905], [132.0, 3003.888888888889], [137.0, 3611.9166666666674], [140.0, 4991.437499999999], [141.0, 4051.809523809523], [143.0, 6715.083333333333], [142.0, 4206.8], [139.0, 6919.5], [138.0, 3353.888888888889], [136.0, 5539.583333333334], [147.0, 3875.72], [150.0, 4799.866666666667], [149.0, 5182.384615384616], [148.0, 3724.565217391304], [146.0, 5116.153846153846], [145.0, 3681.5882352941176], [144.0, 4051.04347826087], [151.0, 2023.68], [154.0, 2611.4999999999995], [157.0, 2872.947368421053], [159.0, 6705.25], [156.0, 5191.384615384615], [155.0, 4563.764705882352], [153.0, 8213.6], [152.0, 3132.266666666667], [158.0, 2238.608695652174], [163.0, 6900.583333333333], [167.0, 3481.5384615384614], [166.0, 6305.823529411764], [165.0, 4386.0], [162.0, 5242.8], [161.0, 7872.944444444445], [160.0, 1911.3], [164.0, 1742.028571428571], [170.0, 4319.818181818182], [173.0, 7651.285714285715], [174.0, 4202.65625], [172.0, 4857.21052631579], [171.0, 2980.272727272727], [169.0, 8775.125], [168.0, 2214.6000000000004], [175.0, 3581.571428571429], [177.0, 5075.666666666667], [180.0, 5140.944444444444], [181.0, 5139.764705882353], [183.0, 5778.666666666666], [179.0, 8812.800000000001], [176.0, 12865.333333333332], [178.0, 1578.7200000000003], [182.0, 2535.4], [184.0, 4419.666666666667], [187.0, 3534.8888888888896], [190.0, 4319.526315789474], [191.0, 3751.407407407408], [189.0, 5382.900000000001], [188.0, 3516.368421052631], [186.0, 5379.0], [185.0, 4305.277777777778], [194.0, 3723.478260869565], [199.0, 4392.263157894738], [198.0, 3038.0555555555557], [197.0, 4363.304347826086], [196.0, 4927.642857142858], [195.0, 4746.058823529412], [193.0, 7025.2], [192.0, 5218.866666666666], [200.0, 6912.5], [203.0, 5821.857142857143], [204.0, 3950.739130434782], [206.0, 9037.857142857143], [207.0, 4361.333333333333], [205.0, 6323.214285714285], [202.0, 3524.136363636363], [201.0, 6097.25], [210.0, 5738.190476190476], [211.0, 5563.266666666666], [213.0, 10487.416666666666], [214.0, 4728.4444444444425], [212.0, 3464.666666666666], [209.0, 5952.8], [208.0, 3753.7619047619055], [215.0, 2775.761904761905], [216.0, 9054.166666666668], [217.0, 5223.25], [220.0, 5368.263157894738], [223.0, 4761.52380952381], [222.0, 7092.230769230769], [221.0, 4523.3125], [219.0, 3706.8823529411766], [218.0, 4294.105263157895], [224.0, 3266.461538461538], [226.0, 5948.857142857143], [227.0, 4129.818181818182], [230.0, 5639.736842105262], [231.0, 4225.727272727274], [229.0, 7578.1], [228.0, 4131.7307692307695], [225.0, 4724.695652173913], [233.0, 7125.3], [234.0, 4507.692307692307], [237.0, 3030.2083333333326], [239.0, 6585.249999999999], [238.0, 10620.3], [236.0, 7998.099999999999], [235.0, 3132.6785714285716], [232.0, 5153.9375], [243.0, 7590.894736842105], [244.0, 5634.294117647059], [246.0, 6911.1], [247.0, 3621.0571428571425], [245.0, 5081.0625], [241.0, 5134.631578947367], [240.0, 5630.187500000001], [242.0, 3914.5384615384614], [253.0, 5653.916666666666], [255.0, 6742.21052631579], [252.0, 7967.75], [251.0, 4443.823529411765], [250.0, 4852.736842105262], [249.0, 8176.083333333333], [248.0, 3446.421052631579], [254.0, 3464.142857142857], [271.0, 4955.956521739131], [257.0, 6018.842105263158], [256.0, 7732.727272727272], [263.0, 6783.615384615384], [262.0, 3341.291666666667], [261.0, 3663.479999999999], [260.0, 5518.636363636364], [264.0, 4098.523809523809], [265.0, 3437.291666666666], [270.0, 7808.571428571429], [269.0, 4605.470588235295], [268.0, 5861.575757575757], [259.0, 4443.083333333333], [258.0, 5284.882352941176], [267.0, 3638.846153846154], [266.0, 5722.5], [287.0, 5003.0], [277.0, 4707.586206896553], [276.0, 3426.0625], [280.0, 6938.869565217391], [284.0, 4608.333333333334], [285.0, 6818.076923076922], [286.0, 5397.111111111111], [283.0, 3846.0999999999995], [282.0, 8885.142857142857], [281.0, 4158.333333333332], [278.0, 4550.0], [275.0, 4184.583333333334], [274.0, 5834.0], [272.0, 7632.4], [279.0, 4036.0], [273.0, 3859.466666666667], [300.0, 6558.941176470589], [296.0, 6991.076923076924], [294.0, 5308.894736842105], [293.0, 6609.909090909092], [292.0, 8306.166666666666], [295.0, 7500.727272727272], [289.0, 6424.333333333334], [288.0, 7422.071428571429], [291.0, 4873.880000000001], [290.0, 5654.875000000001], [297.0, 4045.1200000000003], [301.0, 5327.0526315789475], [303.0, 5873.375000000001], [302.0, 6559.583333333332], [299.0, 6765.444444444444], [298.0, 4555.222222222221], [317.0, 6544.677419354838], [304.0, 4408.464285714286], [305.0, 8265.8], [306.0, 8858.400000000001], [307.0, 5447.21052631579], [316.0, 4688.071428571428], [310.0, 5119.461538461537], [309.0, 5002.142857142857], [308.0, 4531.52380952381], [311.0, 3422.5555555555547], [313.0, 8900.444444444445], [314.0, 4121.31818181818], [315.0, 2775.409090909091], [319.0, 6610.923076923076], [312.0, 5166.6], [318.0, 4677.190476190475], [333.0, 7245.625], [320.0, 5791.88888888889], [323.0, 6238.166666666667], [322.0, 4430.4000000000015], [321.0, 3841.2571428571428], [324.0, 4116.709677419355], [325.0, 4155.833333333333], [326.0, 6311.888888888889], [327.0, 7567.166666666667], [330.0, 5462.727272727272], [329.0, 7352.363636363636], [328.0, 5267.619047619048], [331.0, 4714.739130434784], [334.0, 6068.888888888889], [335.0, 4244.68], [332.0, 6065.0], [350.0, 6480.176470588235], [340.0, 5530.9047619047615], [342.0, 4954.461538461539], [341.0, 5198.166666666667], [343.0, 7631.399999999999], [351.0, 5267.5], [349.0, 7161.454545454544], [348.0, 7676.499999999999], [339.0, 7273.687499999999], [338.0, 4763.95], [337.0, 5957.615384615385], [336.0, 7504.363636363636], [347.0, 4247.578947368422], [346.0, 5811.533333333333], [345.0, 5795.624999999998], [344.0, 5035.952380952381], [364.0, 5799.933333333333], [360.0, 7088.933333333333], [354.0, 5473.719999999998], [353.0, 6837.214285714285], [352.0, 8010.333333333333], [355.0, 5676.857142857143], [359.0, 7315.363636363636], [358.0, 5326.142857142858], [357.0, 6198.588235294117], [356.0, 7997.833333333333], [361.0, 5857.5], [367.0, 7830.866666666668], [366.0, 6299.466666666666], [365.0, 7333.789473684211], [363.0, 6471.666666666666], [362.0, 10166.0], [380.0, 5000.083333333334], [370.0, 8964.307692307691], [371.0, 5237.5625], [375.0, 5760.0], [369.0, 11056.5], [368.0, 7814.7692307692305], [374.0, 7454.791666666666], [372.0, 8802.928571428572], [373.0, 7256.0], [377.0, 5216.2962962962965], [378.0, 6073.368421052633], [379.0, 9945.57142857143], [381.0, 4667.333333333333], [383.0, 7720.761904761905], [376.0, 12662.222222222223], [382.0, 9290.090909090908], [396.0, 11482.875], [386.0, 12024.0], [387.0, 5847.142857142857], [388.0, 6217.7058823529405], [389.0, 8781.9], [390.0, 10711.857142857143], [391.0, 6211.5], [385.0, 5616.374999999999], [384.0, 6799.687500000001], [395.0, 6040.173913043479], [394.0, 5377.217391304348], [393.0, 9481.416666666668], [392.0, 8417.470588235296], [399.0, 6373.400000000001], [397.0, 5399.857142857144], [398.0, 6987.470588235294], [400.0, 7241.181818181818], [401.0, 6530.272727272727], [403.0, 9136.599999999999], [402.0, 7355.666666666666], [413.0, 6240.8421052631575], [412.0, 9176.083333333334], [414.0, 5521.0], [415.0, 6467.38888888889], [404.0, 7022.937500000001], [405.0, 11374.714285714284], [406.0, 9646.375], [407.0, 7067.307692307693], [408.0, 8328.05882352941], [410.0, 9604.800000000001], [409.0, 4812.538461538462], [411.0, 6547.849999999999], [430.0, 6902.2380952380945], [416.0, 10894.5], [417.0, 7908.421052631579], [419.0, 8086.181818181821], [418.0, 6646.578947368421], [429.0, 6392.857142857142], [428.0, 8742.235294117647], [420.0, 7381.176470588235], [421.0, 5614.14814814815], [423.0, 7933.25], [422.0, 8944.111111111111], [424.0, 4907.590909090909], [425.0, 8374.473684210527], [426.0, 7944.714285714285], [427.0, 3888.639999999999], [431.0, 6645.5], [444.0, 7073.900000000001], [434.0, 7297.833333333334], [435.0, 8282.615384615385], [439.0, 8491.875], [433.0, 7847.333333333332], [432.0, 6800.428571428572], [437.0, 7082.5], [436.0, 8982.125], [438.0, 6298.666666666667], [441.0, 6573.733333333334], [443.0, 8993.53846153846], [447.0, 5406.565217391303], [440.0, 5954.476190476191], [446.0, 11109.272727272726], [445.0, 6154.333333333333], [442.0, 9062.133333333333], [460.0, 8258.538461538461], [450.0, 7286.3], [451.0, 4584.099999999999], [454.0, 6888.38888888889], [455.0, 5168.642857142857], [449.0, 8376.777777777777], [448.0, 7451.499999999999], [453.0, 13045.875], [452.0, 7736.6315789473665], [457.0, 5055.879999999999], [456.0, 8034.684210526315], [461.0, 6809.761904761905], [463.0, 13620.166666666666], [462.0, 9065.111111111111], [459.0, 7168.5], [458.0, 6504.6], [467.0, 7313.0666666666675], [468.0, 7834.615384615385], [469.0, 9295.000000000002], [470.0, 7979.428571428572], [471.0, 7506.615384615385], [464.0, 6819.583333333332], [466.0, 7985.461538461538], [465.0, 8231.384615384617], [473.0, 8718.846153846154], [475.0, 5392.899999999999], [474.0, 6906.65], [477.0, 4273.0], [476.0, 9188.9], [479.0, 9927.0], [472.0, 7666.153846153846], [478.0, 9579.375], [483.0, 7470.8823529411775], [484.0, 6953.1], [485.0, 9420.272727272726], [487.0, 6744.666666666667], [482.0, 6754.076923076924], [481.0, 5181.5161290322585], [480.0, 5823.5], [486.0, 10061.777777777777], [490.0, 5617.086956521739], [491.0, 4765.615384615384], [494.0, 6901.650000000001], [495.0, 6965.444444444445], [489.0, 8360.153846153846], [488.0, 5673.954545454546], [493.0, 8073.461538461538], [492.0, 11457.624999999998], [510.0, 10302.499999999998], [497.0, 6145.9], [498.0, 6938.117647058823], [509.0, 13337.5], [508.0, 4074.13043478261], [499.0, 12914.142857142857], [500.0, 10536.666666666666], [501.0, 7879.294117647058], [503.0, 8004.0], [496.0, 11328.000000000002], [502.0, 8568.909090909092], [504.0, 6774.78947368421], [505.0, 7368.25], [507.0, 5897.0], [506.0, 18631.8], [511.0, 7059.578947368421], [538.0, 7481.999999999999], [515.0, 5290.266666666666], [514.0, 7910.705882352942], [513.0, 7307.285714285715], [512.0, 10342.666666666668], [517.0, 5574.653846153847], [516.0, 20447.5], [518.0, 6217.904761904762], [521.0, 5427.080000000001], [520.0, 8256.8125], [522.0, 6061.923076923077], [525.0, 7248.388888888889], [524.0, 7934.789473684212], [523.0, 9603.666666666666], [526.0, 12184.0], [527.0, 6753.9000000000015], [530.0, 6786.111111111113], [529.0, 12179.444444444445], [528.0, 7209.818181818182], [531.0, 6170.0], [543.0, 10353.9], [542.0, 5380.454545454544], [540.0, 5685.521739130435], [539.0, 9860.0], [541.0, 6436.160000000001], [537.0, 5975.909090909092], [536.0, 9445.888888888887], [519.0, 11444.0], [532.0, 8036.857142857142], [533.0, 10116.545454545454], [534.0, 6365.13043478261], [535.0, 8352.076923076922], [551.0, 6554.000000000001], [548.0, 7337.700000000001], [547.0, 6871.5294117647045], [546.0, 10946.300000000001], [545.0, 8554.428571428572], [544.0, 4721.285714285715], [558.0, 5230.421052631579], [559.0, 8349.5], [557.0, 7565.187499999999], [556.0, 9636.875], [550.0, 7538.260869565218], [549.0, 8865.11111111111], [554.0, 8372.941176470587], [553.0, 7233.636363636363], [552.0, 9230.249999999998], [555.0, 6576.444444444446], [561.0, 7073.714285714286], [560.0, 8900.882352941177], [574.0, 8043.785714285716], [573.0, 10332.0], [572.0, 6318.333333333333], [575.0, 6956.25], [568.0, 6922.727272727273], [569.0, 9290.272727272726], [570.0, 6639.0], [571.0, 8927.722222222223], [562.0, 8942.416666666666], [563.0, 7101.846153846154], [564.0, 10370.666666666666], [565.0, 6535.588235294118], [567.0, 7653.266666666666], [566.0, 14461.0], [580.0, 8293.583333333334], [581.0, 7307.04347826087], [583.0, 8517.461538461539], [582.0, 8339.666666666664], [600.0, 7490.65], [601.0, 5102.083333333334], [602.0, 7369.818181818182], [603.0, 9236.249999999998], [604.0, 7084.181818181818], [605.0, 8619.181818181818], [607.0, 5259.310344827588], [593.0, 7320.533333333334], [592.0, 7697.076923076923], [606.0, 12228.0], [584.0, 6504.857142857145], [586.0, 9880.5], [585.0, 9508.5], [587.0, 7100.888888888889], [588.0, 9173.235294117649], [589.0, 7718.75], [590.0, 10589.818181818182], [591.0, 8255.125], [577.0, 6496.500000000001], [576.0, 13739.0], [579.0, 16173.6], [578.0, 7140.266666666667], [594.0, 6366.896551724137], [595.0, 8053.066666666668], [596.0, 12989.125], [597.0, 6737.363636363636], [599.0, 12067.42857142857], [598.0, 5573.380952380954], [633.0, 8019.470588235294], [611.0, 7944.533333333335], [622.0, 9149.0], [608.0, 5746.363636363637], [623.0, 8123.6], [610.0, 7941.2307692307695], [609.0, 8344.230769230768], [632.0, 7811.533333333333], [615.0, 11080.076923076922], [613.0, 7993.916666666666], [614.0, 6667.999999999999], [612.0, 6951.25], [617.0, 7710.5999999999985], [616.0, 9092.818181818182], [618.0, 7983.400000000001], [620.0, 6346.368421052633], [619.0, 8714.666666666668], [621.0, 8754.933333333332], [624.0, 6367.259259259259], [627.0, 5947.190476190476], [626.0, 10101.200000000003], [625.0, 8355.307692307693], [629.0, 8479.923076923076], [628.0, 6193.25], [631.0, 8550.555555555557], [630.0, 8977.461538461537], [634.0, 7991.75], [635.0, 7708.681818181819], [637.0, 6772.083333333333], [636.0, 8879.153846153846], [638.0, 6289.583333333334], [639.0, 7099.090909090909], [645.0, 5560.615384615384], [651.0, 6824.190476190476], [642.0, 8166.846153846154], [641.0, 7259.035714285715], [640.0, 9110.599999999999], [653.0, 8992.153846153846], [652.0, 10559.888888888889], [654.0, 8229.272727272728], [655.0, 9420.642857142859], [644.0, 7528.4444444444425], [643.0, 7917.999999999999], [647.0, 7332.09090909091], [646.0, 11059.555555555555], [664.0, 7132.260869565217], [667.0, 7745.555555555557], [666.0, 10390.285714285716], [665.0, 6405.105263157895], [669.0, 15442.2], [668.0, 4486.772727272727], [670.0, 8696.785714285716], [671.0, 6793.142857142857], [656.0, 8541.21052631579], [657.0, 8654.866666666665], [658.0, 7639.52], [659.0, 8454.066666666666], [660.0, 5029.88], [661.0, 8127.120000000001], [663.0, 9740.947368421053], [662.0, 8739.944444444445], [648.0, 7210.2941176470595], [649.0, 9184.222222222224], [650.0, 6902.809523809523], [678.0, 8196.538461538461], [674.0, 7635.3125], [673.0, 6406.642857142858], [672.0, 9673.916666666666], [675.0, 7494.125], [676.0, 11875.6], [677.0, 6343.846153846154], [688.0, 6330.047619047618], [698.0, 7425.541666666666], [697.0, 6899.470588235294], [696.0, 9936.571428571426], [679.0, 6414.919999999999], [699.0, 8460.428571428572], [700.0, 6362.916666666668], [701.0, 7229.999999999999], [702.0, 7646.8], [703.0, 9716.857142857143], [691.0, 6438.407407407407], [692.0, 6802.5], [690.0, 8931.4375], [689.0, 7035.416666666667], [695.0, 9300.949999999999], [694.0, 6042.210526315789], [693.0, 11040.187499999998], [681.0, 8094.142857142858], [680.0, 8124.083333333335], [683.0, 7064.866666666668], [682.0, 9528.22222222222], [684.0, 7742.578947368422], [687.0, 6216.9], [686.0, 11329.5], [685.0, 6217.64705882353], [728.0, 7177.612903225808], [717.0, 8733.0], [704.0, 6681.846153846153], [706.0, 11579.5], [705.0, 7998.812500000002], [707.0, 9667.0625], [708.0, 8390.055555555557], [709.0, 8785.384615384615], [711.0, 6026.772727272727], [710.0, 6338.041666666666], [730.0, 9335.235294117647], [729.0, 11464.500000000002], [731.0, 8330.809523809525], [734.0, 9536.526315789475], [733.0, 9367.764705882353], [732.0, 8095.999999999999], [735.0, 8338.5], [721.0, 5753.899999999999], [720.0, 7422.384615384615], [723.0, 7840.384615384615], [722.0, 11212.25], [713.0, 8082.1], [712.0, 7593.375000000001], [714.0, 8665.85], [715.0, 9734.133333333333], [716.0, 10034.307692307693], [718.0, 6675.375], [719.0, 10829.384615384617], [724.0, 8681.357142857141], [725.0, 6431.192307692309], [727.0, 11593.25], [726.0, 9711.5], [760.0, 5215.200000000001], [750.0, 7974.823529411766], [737.0, 6864.684210526314], [739.0, 10651.0], [738.0, 6150.899999999999], [740.0, 8382.23529411765], [743.0, 10847.583333333334], [742.0, 7591.058823529411], [741.0, 7419.285714285714], [761.0, 7750.714285714286], [763.0, 7447.533333333334], [762.0, 5911.157894736843], [764.0, 6314.649999999998], [767.0, 7364.368421052631], [752.0, 6175.65], [766.0, 10596.636363636364], [765.0, 6799.000000000001], [744.0, 5024.096774193547], [745.0, 10190.058823529413], [748.0, 6899.043478260869], [747.0, 6266.217391304347], [746.0, 7929.25], [749.0, 7115.055555555557], [751.0, 6749.588235294117], [736.0, 8304.5], [753.0, 6278.0952380952385], [754.0, 8893.000000000002], [755.0, 12307.526315789471], [757.0, 6473.5], [756.0, 7348.125], [758.0, 6146.454545454546], [759.0, 10005.368421052632], [773.0, 11018.4], [771.0, 7715.521739130434], [770.0, 3685.541666666666], [769.0, 5555.5], [768.0, 6116.333333333332], [772.0, 6475.363636363636], [774.0, 6553.399999999999], [775.0, 6296.4375], [777.0, 4482.96], [776.0, 7432.1578947368425], [779.0, 7842.826086956523], [778.0, 5583.533333333334], [780.0, 7871.916666666668], [781.0, 7804.363636363636], [782.0, 9290.117647058823], [783.0, 8587.4375], [784.0, 6839.923076923077], [786.0, 9797.384615384615], [785.0, 6074.833333333334], [799.0, 6737.714285714286], [793.0, 6999.454545454546], [792.0, 8705.318181818182], [795.0, 8162.882352941178], [794.0, 7503.47619047619], [797.0, 7848.687499999999], [796.0, 6734.499999999999], [798.0, 6543.166666666668], [787.0, 6861.478260869564], [790.0, 6238.714285714285], [788.0, 7388.8888888888905], [789.0, 8175.900000000001], [791.0, 6564.130434782608], [807.0, 6992.500000000001], [801.0, 7699.608695652175], [800.0, 8317.588235294119], [815.0, 5675.588235294119], [814.0, 9407.166666666666], [813.0, 6817.649999999999], [804.0, 8402.857142857143], [803.0, 8394.823529411764], [802.0, 6151.857142857143], [805.0, 8800.636363636364], [806.0, 10378.555555555555], [817.0, 9511.250000000002], [816.0, 10151.0], [830.0, 6620.074074074074], [829.0, 6474.866666666666], [831.0, 7102.727272727272], [827.0, 7713.0666666666675], [826.0, 7100.333333333334], [828.0, 4817.0526315789475], [824.0, 7595.625], [825.0, 5430.5714285714275], [818.0, 7251.35294117647], [820.0, 7939.636363636363], [819.0, 8180.200000000001], [821.0, 6488.0], [822.0, 7694.7], [823.0, 5467.045454545454], [808.0, 7121.333333333334], [809.0, 5413.166666666667], [810.0, 4863.111111111111], [811.0, 8900.772727272726], [812.0, 8386.1], [857.0, 6429.619047619048], [843.0, 9417.684210526317], [834.0, 7565.705882352941], [833.0, 8641.64705882353], [832.0, 7035.846153846152], [836.0, 10105.3125], [835.0, 12269.772727272728], [837.0, 6957.793103448277], [838.0, 6924.0], [856.0, 12895.153846153846], [839.0, 10370.625], [858.0, 7795.458333333335], [859.0, 6713.5], [860.0, 11221.4375], [861.0, 7925.111111111112], [863.0, 10853.230769230768], [862.0, 10392.857142857143], [840.0, 8124.124999999998], [841.0, 9358.666666666668], [842.0, 10873.22222222222], [844.0, 9120.368421052632], [846.0, 8658.333333333334], [845.0, 8938.25], [847.0, 6558.199999999999], [848.0, 10079.466666666667], [850.0, 8179.166666666668], [849.0, 7386.1111111111095], [851.0, 9620.068965517243], [854.0, 7662.192307692307], [853.0, 7014.3125], [852.0, 9503.473684210529], [855.0, 7189.3], [868.0, 7550.029411764706], [864.0, 7424.9], [865.0, 6575.809523809523], [867.0, 10177.28571428572], [866.0, 8816.857142857143], [870.0, 5368.347826086955], [869.0, 9215.400000000001], [871.0, 7493.038461538462], [878.0, 9972.947368421052], [877.0, 6728.44], [876.0, 8759.222222222223], [875.0, 9722.533333333333], [874.0, 9482.499999999998], [873.0, 10143.823529411766], [872.0, 7384.500000000001], [879.0, 7537.0], [883.0, 10829.57142857143], [882.0, 5329.470588235294], [881.0, 7424.212121212121], [880.0, 8139.523809523808], [885.0, 11319.727272727272], [884.0, 13538.312500000002], [891.0, 7992.999999999999], [894.0, 6033.823529411765], [893.0, 13221.5], [892.0, 7803.437500000001], [895.0, 9583.941176470587], [888.0, 7894.866666666666], [889.0, 7920.1875], [890.0, 8628.444444444443], [886.0, 10722.000000000002], [887.0, 11418.277777777777], [897.0, 8317.222222222223], [901.0, 8130.799999999999], [900.0, 9728.5], [899.0, 11798.57142857143], [898.0, 7696.842105263159], [903.0, 12503.249999999998], [902.0, 8206.0], [920.0, 7887.771428571426], [923.0, 8897.666666666668], [922.0, 10500.555555555557], [921.0, 5574.733333333334], [924.0, 8723.863636363634], [925.0, 6176.136363636364], [927.0, 6146.214285714285], [913.0, 13082.733333333334], [912.0, 9158.173913043476], [926.0, 13305.105263157893], [904.0, 9695.55], [905.0, 9479.214285714284], [907.0, 9741.285714285712], [906.0, 11053.166666666668], [908.0, 9356.166666666668], [911.0, 8256.0], [896.0, 10258.0], [910.0, 8601.952380952383], [909.0, 8984.363636363636], [914.0, 7753.575000000001], [915.0, 8531.03846153846], [916.0, 11796.928571428572], [917.0, 8207.772727272728], [918.0, 8766.875000000002], [919.0, 9177.5], [934.0, 8743.090909090908], [940.0, 7863.032258064516], [931.0, 7920.04], [928.0, 10134.633333333333], [930.0, 6412.318181818182], [929.0, 8021.520000000001], [941.0, 7422.124999999999], [942.0, 5747.428571428571], [943.0, 9795.121212121212], [933.0, 8067.382352941176], [932.0, 10570.650000000001], [935.0, 7682.285714285715], [953.0, 10431.444444444445], [952.0, 13353.299999999997], [954.0, 6996.343749999999], [957.0, 8325.208333333334], [956.0, 9188.0], [955.0, 10144.105263157895], [958.0, 6031.884615384615], [959.0, 9473.473684210529], [944.0, 9385.263157894737], [946.0, 9479.944444444443], [945.0, 5357.250000000001], [947.0, 9483.82142857143], [948.0, 9070.791666666668], [949.0, 7092.833333333333], [950.0, 10505.359999999999], [951.0, 6527.377777777778], [936.0, 12832.785714285716], [937.0, 8687.05], [938.0, 9540.968750000002], [939.0, 9320.739130434784], [984.0, 8910.039215686274], [973.0, 9118.405405405403], [961.0, 9228.18918918919], [960.0, 12417.049999999997], [963.0, 9048.25], [962.0, 10317.576923076926], [964.0, 11517.838709677419], [965.0, 6004.9333333333325], [966.0, 8675.066666666666], [967.0, 7227.205882352942], [987.0, 12288.962962962964], [986.0, 10227.884615384615], [985.0, 8478.52], [988.0, 9981.866666666669], [991.0, 12332.139534883721], [976.0, 14338.0], [990.0, 8635.53125], [989.0, 7574.3448275862065], [968.0, 9587.551724137933], [969.0, 9851.542857142858], [970.0, 12781.545454545449], [971.0, 6753.410256410257], [972.0, 8918.8], [975.0, 12258.851851851852], [974.0, 13136.28], [977.0, 7508.967741935484], [978.0, 9855.100000000002], [979.0, 7052.846153846153], [980.0, 11046.951219512195], [981.0, 8653.574999999999], [982.0, 11637.528301886794], [983.0, 10299.690476190477], [994.0, 7461.639534883724], [992.0, 10096.870370370372], [998.0, 8382.000000000002], [1000.0, 9219.306185476033], [999.0, 11040.051282051289], [997.0, 9089.982758620688], [996.0, 9930.71428571429], [995.0, 9760.045454545452], [993.0, 11791.814814814818], [1.0, 12581.25]], "isOverall": false, "label": "HTTP Request", "isController": false}, {"data": [[716.5472970682873, 7801.814675478764]], "isOverall": false, "label": "HTTP Request-Aggregated", "isController": false}], "supportsControllersDiscrimination": true, "maxX": 1000.0, "title": "Time VS Threads"}},
        getOptions: function() {
            return {
                series: {
                    lines: {
                        show: true
                    },
                    points: {
                        show: true
                    }
                },
                xaxis: {
                    axisLabel: "Number of active threads",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                yaxis: {
                    axisLabel: "Average response times in ms",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20
                },
                legend: { noColumns: 2,show: true, container: '#legendTimeVsThreads' },
                selection: {
                    mode: 'xy'
                },
                grid: {
                    hoverable: true // IMPORTANT! this is needed for tooltip to work
                },
                tooltip: true,
                tooltipOpts: {
                    content: "%s: At %x.2 active threads, Average response time was %y.2 ms"
                }
            };
        },
        createGraph: function() {
            var data = this.data;
            var dataset = prepareData(data.result.series, $("#choicesTimeVsThreads"));
            var options = this.getOptions();
            prepareOptions(options, data);
            $.plot($("#flotTimesVsThreads"), dataset, options);
            // setup overview
            $.plot($("#overviewTimesVsThreads"), dataset, prepareOverviewOptions(options));
        }
};

// Time vs threads
function refreshTimeVsThreads(){
    var infos = timeVsThreadsInfos;
    prepareSeries(infos.data);
    if(infos.data.result.series.length == 0) {
        setEmptyGraph("#bodyTimeVsThreads");
        return;
    }
    if(isGraph($("#flotTimesVsThreads"))){
        infos.createGraph();
    }else{
        var choiceContainer = $("#choicesTimeVsThreads");
        createLegend(choiceContainer, infos);
        infos.createGraph();
        setGraphZoomable("#flotTimesVsThreads", "#overviewTimesVsThreads");
        $('#footerTimeVsThreads .legendColorBox > div').each(function(i){
            $(this).clone().prependTo(choiceContainer.find("li").eq(i));
        });
    }
};

var bytesThroughputOverTimeInfos = {
        data : {"result": {"minY": 2169.6, "minX": 1.6982169E12, "maxY": 16938.916666666668, "series": [{"data": [[1.69821714E12, 15736.8], [1.69821696E12, 5675.35], [1.69821702E12, 15158.4], [1.6982172E12, 11841.6], [1.6982169E12, 2169.6], [1.69821726E12, 10677.6], [1.69821708E12, 9583.2]], "isOverall": false, "label": "Bytes received per second", "isController": false}, {"data": [[1.69821714E12, 16938.916666666668], [1.69821696E12, 6076.0], [1.69821702E12, 16316.333333333334], [1.6982172E12, 12746.166666666666], [1.6982169E12, 2335.3333333333335], [1.69821726E12, 11493.25], [1.69821708E12, 10315.25]], "isOverall": false, "label": "Bytes sent per second", "isController": false}], "supportsControllersDiscrimination": false, "granularity": 60000, "maxX": 1.69821726E12, "title": "Bytes Throughput Over Time"}},
        getOptions : function(){
            return {
                series: {
                    lines: {
                        show: true
                    },
                    points: {
                        show: true
                    }
                },
                xaxis: {
                    mode: "time",
                    timeformat: getTimeFormat(this.data.result.granularity),
                    axisLabel: getElapsedTimeLabel(this.data.result.granularity) ,
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                yaxis: {
                    axisLabel: "Bytes / sec",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                legend: {
                    noColumns: 2,
                    show: true,
                    container: '#legendBytesThroughputOverTime'
                },
                selection: {
                    mode: "xy"
                },
                grid: {
                    hoverable: true // IMPORTANT! this is needed for tooltip to
                                    // work
                },
                tooltip: true,
                tooltipOpts: {
                    content: "%s at %x was %y"
                }
            };
        },
        createGraph : function() {
            var data = this.data;
            var dataset = prepareData(data.result.series, $("#choicesBytesThroughputOverTime"));
            var options = this.getOptions();
            prepareOptions(options, data);
            $.plot($("#flotBytesThroughputOverTime"), dataset, options);
            // setup overview
            $.plot($("#overviewBytesThroughputOverTime"), dataset, prepareOverviewOptions(options));
        }
};

// Bytes throughput Over Time
function refreshBytesThroughputOverTime(fixTimestamps) {
    var infos = bytesThroughputOverTimeInfos;
    prepareSeries(infos.data);
    if(fixTimestamps) {
        fixTimeStamps(infos.data.result.series, 10800000);
    }
    if(isGraph($("#flotBytesThroughputOverTime"))){
        infos.createGraph();
    }else{
        var choiceContainer = $("#choicesBytesThroughputOverTime");
        createLegend(choiceContainer, infos);
        infos.createGraph();
        setGraphZoomable("#flotBytesThroughputOverTime", "#overviewBytesThroughputOverTime");
        $('#footerBytesThroughputOverTime .legendColorBox > div').each(function(i){
            $(this).clone().prependTo(choiceContainer.find("li").eq(i));
        });
    }
}

var responseTimesOverTimeInfos = {
        data: {"result": {"minY": 3935.28455614106, "minX": 1.6982169E12, "maxY": 22230.600765306146, "series": [{"data": [[1.69821714E12, 7271.570535305779], [1.69821696E12, 22230.600765306146], [1.69821702E12, 4789.411652944895], [1.6982172E12, 3935.28455614106], [1.6982169E12, 9584.926991150436], [1.69821726E12, 9777.87997302768], [1.69821708E12, 7110.76909591785]], "isOverall": false, "label": "HTTP Request", "isController": false}], "supportsControllersDiscrimination": true, "granularity": 60000, "maxX": 1.69821726E12, "title": "Response Time Over Time"}},
        getOptions: function(){
            return {
                series: {
                    lines: {
                        show: true
                    },
                    points: {
                        show: true
                    }
                },
                xaxis: {
                    mode: "time",
                    timeformat: getTimeFormat(this.data.result.granularity),
                    axisLabel: getElapsedTimeLabel(this.data.result.granularity),
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                yaxis: {
                    axisLabel: "Average response time in ms",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                legend: {
                    noColumns: 2,
                    show: true,
                    container: '#legendResponseTimesOverTime'
                },
                selection: {
                    mode: 'xy'
                },
                grid: {
                    hoverable: true // IMPORTANT! this is needed for tooltip to
                                    // work
                },
                tooltip: true,
                tooltipOpts: {
                    content: "%s : at %x Average response time was %y ms"
                }
            };
        },
        createGraph: function() {
            var data = this.data;
            var dataset = prepareData(data.result.series, $("#choicesResponseTimesOverTime"));
            var options = this.getOptions();
            prepareOptions(options, data);
            $.plot($("#flotResponseTimesOverTime"), dataset, options);
            // setup overview
            $.plot($("#overviewResponseTimesOverTime"), dataset, prepareOverviewOptions(options));
        }
};

// Response Times Over Time
function refreshResponseTimeOverTime(fixTimestamps) {
    var infos = responseTimesOverTimeInfos;
    prepareSeries(infos.data);
    if(infos.data.result.series.length == 0) {
        setEmptyGraph("#bodyResponseTimeOverTime");
        return;
    }
    if(fixTimestamps) {
        fixTimeStamps(infos.data.result.series, 10800000);
    }
    if(isGraph($("#flotResponseTimesOverTime"))){
        infos.createGraph();
    }else{
        var choiceContainer = $("#choicesResponseTimesOverTime");
        createLegend(choiceContainer, infos);
        infos.createGraph();
        setGraphZoomable("#flotResponseTimesOverTime", "#overviewResponseTimesOverTime");
        $('#footerResponseTimesOverTime .legendColorBox > div').each(function(i){
            $(this).clone().prependTo(choiceContainer.find("li").eq(i));
        });
    }
};

var latenciesOverTimeInfos = {
        data: {"result": {"minY": 3935.232265910018, "minX": 1.6982169E12, "maxY": 22230.558248299316, "series": [{"data": [[1.69821714E12, 7271.533933201139], [1.69821696E12, 22230.558248299316], [1.69821702E12, 4789.38125395818], [1.6982172E12, 3935.232265910018], [1.6982169E12, 9584.848451327427], [1.69821726E12, 9777.84513373794], [1.69821708E12, 7110.735787628362]], "isOverall": false, "label": "HTTP Request", "isController": false}], "supportsControllersDiscrimination": true, "granularity": 60000, "maxX": 1.69821726E12, "title": "Latencies Over Time"}},
        getOptions: function() {
            return {
                series: {
                    lines: {
                        show: true
                    },
                    points: {
                        show: true
                    }
                },
                xaxis: {
                    mode: "time",
                    timeformat: getTimeFormat(this.data.result.granularity),
                    axisLabel: getElapsedTimeLabel(this.data.result.granularity),
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                yaxis: {
                    axisLabel: "Average response latencies in ms",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                legend: {
                    noColumns: 2,
                    show: true,
                    container: '#legendLatenciesOverTime'
                },
                selection: {
                    mode: 'xy'
                },
                grid: {
                    hoverable: true // IMPORTANT! this is needed for tooltip to
                                    // work
                },
                tooltip: true,
                tooltipOpts: {
                    content: "%s : at %x Average latency was %y ms"
                }
            };
        },
        createGraph: function () {
            var data = this.data;
            var dataset = prepareData(data.result.series, $("#choicesLatenciesOverTime"));
            var options = this.getOptions();
            prepareOptions(options, data);
            $.plot($("#flotLatenciesOverTime"), dataset, options);
            // setup overview
            $.plot($("#overviewLatenciesOverTime"), dataset, prepareOverviewOptions(options));
        }
};

// Latencies Over Time
function refreshLatenciesOverTime(fixTimestamps) {
    var infos = latenciesOverTimeInfos;
    prepareSeries(infos.data);
    if(infos.data.result.series.length == 0) {
        setEmptyGraph("#bodyLatenciesOverTime");
        return;
    }
    if(fixTimestamps) {
        fixTimeStamps(infos.data.result.series, 10800000);
    }
    if(isGraph($("#flotLatenciesOverTime"))) {
        infos.createGraph();
    }else {
        var choiceContainer = $("#choicesLatenciesOverTime");
        createLegend(choiceContainer, infos);
        infos.createGraph();
        setGraphZoomable("#flotLatenciesOverTime", "#overviewLatenciesOverTime");
        $('#footerLatenciesOverTime .legendColorBox > div').each(function(i){
            $(this).clone().prependTo(choiceContainer.find("li").eq(i));
        });
    }
};

var connectTimeOverTimeInfos = {
        data: {"result": {"minY": 1.7770571544385876, "minX": 1.6982169E12, "maxY": 3.19137168141593, "series": [{"data": [[1.69821714E12, 1.8651822479792572], [1.69821696E12, 2.494472789115644], [1.69821702E12, 2.1559531348955026], [1.6982172E12, 1.7770571544385876], [1.6982169E12, 3.19137168141593], [1.69821726E12, 2.0089907844459387], [1.69821708E12, 2.0859003255697477]], "isOverall": false, "label": "HTTP Request", "isController": false}], "supportsControllersDiscrimination": true, "granularity": 60000, "maxX": 1.69821726E12, "title": "Connect Time Over Time"}},
        getOptions: function() {
            return {
                series: {
                    lines: {
                        show: true
                    },
                    points: {
                        show: true
                    }
                },
                xaxis: {
                    mode: "time",
                    timeformat: getTimeFormat(this.data.result.granularity),
                    axisLabel: getConnectTimeLabel(this.data.result.granularity),
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                yaxis: {
                    axisLabel: "Average Connect Time in ms",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                legend: {
                    noColumns: 2,
                    show: true,
                    container: '#legendConnectTimeOverTime'
                },
                selection: {
                    mode: 'xy'
                },
                grid: {
                    hoverable: true // IMPORTANT! this is needed for tooltip to
                                    // work
                },
                tooltip: true,
                tooltipOpts: {
                    content: "%s : at %x Average connect time was %y ms"
                }
            };
        },
        createGraph: function () {
            var data = this.data;
            var dataset = prepareData(data.result.series, $("#choicesConnectTimeOverTime"));
            var options = this.getOptions();
            prepareOptions(options, data);
            $.plot($("#flotConnectTimeOverTime"), dataset, options);
            // setup overview
            $.plot($("#overviewConnectTimeOverTime"), dataset, prepareOverviewOptions(options));
        }
};

// Connect Time Over Time
function refreshConnectTimeOverTime(fixTimestamps) {
    var infos = connectTimeOverTimeInfos;
    prepareSeries(infos.data);
    if(infos.data.result.series.length == 0) {
        setEmptyGraph("#bodyConnectTimeOverTime");
        return;
    }
    if(fixTimestamps) {
        fixTimeStamps(infos.data.result.series, 10800000);
    }
    if(isGraph($("#flotConnectTimeOverTime"))) {
        infos.createGraph();
    }else {
        var choiceContainer = $("#choicesConnectTimeOverTime");
        createLegend(choiceContainer, infos);
        infos.createGraph();
        setGraphZoomable("#flotConnectTimeOverTime", "#overviewConnectTimeOverTime");
        $('#footerConnectTimeOverTime .legendColorBox > div').each(function(i){
            $(this).clone().prependTo(choiceContainer.find("li").eq(i));
        });
    }
};

var responseTimePercentilesOverTimeInfos = {
        data: {"result": {"minY": 25.0, "minX": 1.6982169E12, "maxY": 39996.0, "series": [{"data": [[1.69821714E12, 21989.0], [1.69821696E12, 39996.0], [1.69821702E12, 24848.0], [1.6982172E12, 24951.0], [1.6982169E12, 21751.0], [1.69821726E12, 23512.0], [1.69821708E12, 29257.0]], "isOverall": false, "label": "Max", "isController": false}, {"data": [[1.69821714E12, 16165.0], [1.69821696E12, 32319.0], [1.69821702E12, 13156.900000000001], [1.6982172E12, 10447.5], [1.6982169E12, 16015.0], [1.69821726E12, 16409.0], [1.69821708E12, 17397.0]], "isOverall": false, "label": "90th percentile", "isController": false}, {"data": [[1.69821714E12, 18182.52], [1.69821696E12, 34103.99999999999], [1.69821702E12, 18966.83], [1.6982172E12, 16909.549999999996], [1.6982169E12, 20935.9], [1.69821726E12, 18259.5], [1.69821708E12, 24528.96]], "isOverall": false, "label": "99th percentile", "isController": false}, {"data": [[1.69821714E12, 16866.199999999997], [1.69821696E12, 32920.0], [1.69821702E12, 15304.199999999997], [1.6982172E12, 14025.25], [1.6982169E12, 18704.0], [1.69821726E12, 17042.5], [1.69821708E12, 19537.0]], "isOverall": false, "label": "95th percentile", "isController": false}, {"data": [[1.69821714E12, 27.0], [1.69821696E12, 33.0], [1.69821702E12, 25.0], [1.6982172E12, 26.0], [1.6982169E12, 108.0], [1.69821726E12, 26.0], [1.69821708E12, 28.0]], "isOverall": false, "label": "Min", "isController": false}, {"data": [[1.69821714E12, 6523.0], [1.69821696E12, 27802.0], [1.69821702E12, 2929.0], [1.6982172E12, 1680.0], [1.6982169E12, 9386.5], [1.69821726E12, 13202.0], [1.69821708E12, 2360.0]], "isOverall": false, "label": "Median", "isController": false}], "supportsControllersDiscrimination": false, "granularity": 60000, "maxX": 1.69821726E12, "title": "Response Time Percentiles Over Time (successful requests only)"}},
        getOptions: function() {
            return {
                series: {
                    lines: {
                        show: true,
                        fill: true
                    },
                    points: {
                        show: true
                    }
                },
                xaxis: {
                    mode: "time",
                    timeformat: getTimeFormat(this.data.result.granularity),
                    axisLabel: getElapsedTimeLabel(this.data.result.granularity),
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                yaxis: {
                    axisLabel: "Response Time in ms",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                legend: {
                    noColumns: 2,
                    show: true,
                    container: '#legendResponseTimePercentilesOverTime'
                },
                selection: {
                    mode: 'xy'
                },
                grid: {
                    hoverable: true // IMPORTANT! this is needed for tooltip to
                                    // work
                },
                tooltip: true,
                tooltipOpts: {
                    content: "%s : at %x Response time was %y ms"
                }
            };
        },
        createGraph: function () {
            var data = this.data;
            var dataset = prepareData(data.result.series, $("#choicesResponseTimePercentilesOverTime"));
            var options = this.getOptions();
            prepareOptions(options, data);
            $.plot($("#flotResponseTimePercentilesOverTime"), dataset, options);
            // setup overview
            $.plot($("#overviewResponseTimePercentilesOverTime"), dataset, prepareOverviewOptions(options));
        }
};

// Response Time Percentiles Over Time
function refreshResponseTimePercentilesOverTime(fixTimestamps) {
    var infos = responseTimePercentilesOverTimeInfos;
    prepareSeries(infos.data);
    if(fixTimestamps) {
        fixTimeStamps(infos.data.result.series, 10800000);
    }
    if(isGraph($("#flotResponseTimePercentilesOverTime"))) {
        infos.createGraph();
    }else {
        var choiceContainer = $("#choicesResponseTimePercentilesOverTime");
        createLegend(choiceContainer, infos);
        infos.createGraph();
        setGraphZoomable("#flotResponseTimePercentilesOverTime", "#overviewResponseTimePercentilesOverTime");
        $('#footerResponseTimePercentilesOverTime .legendColorBox > div').each(function(i){
            $(this).clone().prependTo(choiceContainer.find("li").eq(i));
        });
    }
};


var responseTimeVsRequestInfos = {
    data: {"result": {"minY": 6.0, "minX": 4.0, "maxY": 31932.0, "series": [{"data": [[4.0, 262.0], [9.0, 53.0], [12.0, 64.5], [14.0, 7555.5], [15.0, 4643.0], [17.0, 23007.0], [18.0, 3476.5], [19.0, 7691.5], [20.0, 1654.5], [21.0, 3929.0], [22.0, 9505.0], [23.0, 6800.0], [24.0, 13599.0], [25.0, 11097.0], [27.0, 25789.0], [28.0, 13959.0], [29.0, 27416.0], [30.0, 8826.5], [31.0, 28095.0], [33.0, 9662.0], [32.0, 27284.0], [34.0, 11506.0], [36.0, 26042.0], [37.0, 26827.5], [38.0, 10488.5], [39.0, 23858.5], [40.0, 7098.5], [41.0, 14934.5], [43.0, 29610.0], [42.0, 31023.5], [45.0, 31932.0], [44.0, 13238.5], [47.0, 14669.0], [49.0, 15041.0], [51.0, 21608.0], [50.0, 15794.5], [52.0, 27656.0], [53.0, 15197.0], [55.0, 14587.0], [54.0, 30133.0], [56.0, 17076.0], [57.0, 16065.0], [58.0, 12594.5], [60.0, 27890.5], [61.0, 15687.0], [62.0, 14862.0], [63.0, 13699.0], [67.0, 4762.0], [66.0, 10960.5], [69.0, 10068.0], [70.0, 5992.0], [68.0, 7812.5], [71.0, 13638.0], [74.0, 13801.5], [72.0, 15119.5], [75.0, 9708.0], [78.0, 30559.0], [79.0, 14207.0], [76.0, 13602.5], [80.0, 13462.0], [81.0, 15220.5], [83.0, 14993.0], [84.0, 14223.5], [87.0, 2824.0], [85.0, 11573.0], [86.0, 10648.0], [88.0, 13660.0], [91.0, 16195.0], [90.0, 9484.5], [89.0, 12797.5], [92.0, 9067.5], [93.0, 4895.5], [95.0, 9219.0], [94.0, 9609.5], [97.0, 17892.0], [99.0, 4054.0], [98.0, 7433.5], [102.0, 4780.5], [103.0, 11087.0], [100.0, 11233.0], [101.0, 15429.0], [104.0, 4310.5], [106.0, 4124.5], [105.0, 13587.0], [107.0, 894.0], [111.0, 4028.5], [110.0, 6953.5], [109.0, 3220.0], [108.0, 2397.5], [112.0, 1077.5], [115.0, 2745.0], [114.0, 5772.5], [113.0, 2964.0], [117.0, 2788.0], [118.0, 2034.0], [116.0, 2810.5], [123.0, 1828.0], [122.0, 2120.0], [120.0, 1054.5], [121.0, 136.0], [125.0, 4532.5], [124.0, 7792.0], [127.0, 1658.5], [126.0, 2325.5], [132.0, 2300.5], [130.0, 1901.5], [129.0, 4444.0], [131.0, 511.0], [128.0, 6405.5], [134.0, 9584.5], [133.0, 2982.0], [135.0, 636.5], [138.0, 694.5], [143.0, 1294.0], [139.0, 5394.0], [142.0, 12570.0], [141.0, 4261.5], [136.0, 4675.0], [140.0, 5560.0], [151.0, 802.0], [146.0, 897.0], [145.0, 3359.5], [150.0, 899.5], [148.0, 613.5], [149.0, 676.0], [144.0, 970.5], [147.0, 1998.0], [159.0, 1327.5], [157.0, 9448.0], [152.0, 1602.5], [155.0, 910.0], [154.0, 8167.0], [158.0, 2582.0], [153.0, 666.0], [162.0, 14323.5], [163.0, 5532.0], [171.0, 1026.0], [174.0, 8978.0], [168.0, 8798.0], [172.0, 12149.5], [177.0, 10677.0], [185.0, 13968.0], [197.0, 13493.0], [200.0, 12956.5], [211.0, 11639.0]], "isOverall": false, "label": "Successes", "isController": false}, {"data": [[32.0, 6.0], [69.0, 25.0], [42.0, 13.0], [23.0, 12.0], [56.0, 12.0], [29.0, 15.0]], "isOverall": false, "label": "Failures", "isController": false}], "supportsControllersDiscrimination": false, "granularity": 1000, "maxX": 211.0, "title": "Response Time Vs Request"}},
    getOptions: function() {
        return {
            series: {
                lines: {
                    show: false
                },
                points: {
                    show: true
                }
            },
            xaxis: {
                axisLabel: "Global number of requests per second",
                axisLabelUseCanvas: true,
                axisLabelFontSizePixels: 12,
                axisLabelFontFamily: 'Verdana, Arial',
                axisLabelPadding: 20,
            },
            yaxis: {
                axisLabel: "Median Response Time in ms",
                axisLabelUseCanvas: true,
                axisLabelFontSizePixels: 12,
                axisLabelFontFamily: 'Verdana, Arial',
                axisLabelPadding: 20,
            },
            legend: {
                noColumns: 2,
                show: true,
                container: '#legendResponseTimeVsRequest'
            },
            selection: {
                mode: 'xy'
            },
            grid: {
                hoverable: true // IMPORTANT! this is needed for tooltip to work
            },
            tooltip: true,
            tooltipOpts: {
                content: "%s : Median response time at %x req/s was %y ms"
            },
            colors: ["#9ACD32", "#FF6347"]
        };
    },
    createGraph: function () {
        var data = this.data;
        var dataset = prepareData(data.result.series, $("#choicesResponseTimeVsRequest"));
        var options = this.getOptions();
        prepareOptions(options, data);
        $.plot($("#flotResponseTimeVsRequest"), dataset, options);
        // setup overview
        $.plot($("#overviewResponseTimeVsRequest"), dataset, prepareOverviewOptions(options));

    }
};

// Response Time vs Request
function refreshResponseTimeVsRequest() {
    var infos = responseTimeVsRequestInfos;
    prepareSeries(infos.data);
    if (isGraph($("#flotResponseTimeVsRequest"))){
        infos.createGraph();
    }else{
        var choiceContainer = $("#choicesResponseTimeVsRequest");
        createLegend(choiceContainer, infos);
        infos.createGraph();
        setGraphZoomable("#flotResponseTimeVsRequest", "#overviewResponseTimeVsRequest");
        $('#footerResponseRimeVsRequest .legendColorBox > div').each(function(i){
            $(this).clone().prependTo(choiceContainer.find("li").eq(i));
        });
    }
};


var latenciesVsRequestInfos = {
    data: {"result": {"minY": 6.0, "minX": 4.0, "maxY": 31932.0, "series": [{"data": [[4.0, 262.0], [9.0, 53.0], [12.0, 64.0], [14.0, 7555.5], [15.0, 4643.0], [17.0, 23007.0], [18.0, 3476.5], [19.0, 7691.5], [20.0, 1654.5], [21.0, 3929.0], [22.0, 9505.0], [23.0, 6800.0], [24.0, 13599.0], [25.0, 11097.0], [27.0, 25789.0], [28.0, 13959.0], [29.0, 27416.0], [30.0, 8826.5], [31.0, 28095.0], [33.0, 9662.0], [32.0, 27284.0], [34.0, 11505.5], [36.0, 26042.0], [37.0, 26827.5], [38.0, 10488.5], [39.0, 23858.5], [40.0, 7098.5], [41.0, 14934.5], [43.0, 29610.0], [42.0, 31023.5], [45.0, 31932.0], [44.0, 13238.5], [47.0, 14669.0], [49.0, 15041.0], [51.0, 21608.0], [50.0, 15794.5], [52.0, 27656.0], [53.0, 15197.0], [55.0, 14587.0], [54.0, 30133.0], [56.0, 17076.0], [57.0, 16065.0], [58.0, 12594.0], [60.0, 27890.5], [61.0, 15687.0], [62.0, 14862.0], [63.0, 13699.0], [67.0, 4762.0], [66.0, 10960.5], [69.0, 10068.0], [70.0, 5992.0], [68.0, 7812.5], [71.0, 13638.0], [74.0, 13801.5], [72.0, 15119.5], [75.0, 9708.0], [78.0, 30559.0], [79.0, 14207.0], [76.0, 13602.5], [80.0, 13462.0], [81.0, 15220.5], [83.0, 14993.0], [84.0, 14223.5], [87.0, 2824.0], [85.0, 11573.0], [86.0, 10648.0], [88.0, 13660.0], [91.0, 16195.0], [90.0, 9484.5], [89.0, 12797.5], [92.0, 9067.5], [93.0, 4895.5], [95.0, 9219.0], [94.0, 9609.5], [97.0, 17892.0], [99.0, 4054.0], [98.0, 7433.0], [102.0, 4780.5], [103.0, 11087.0], [100.0, 11233.0], [101.0, 15429.0], [104.0, 4310.5], [106.0, 4124.5], [105.0, 13586.5], [107.0, 894.0], [111.0, 4028.5], [110.0, 6953.5], [109.0, 3220.0], [108.0, 2397.5], [112.0, 1077.5], [115.0, 2745.0], [114.0, 5772.0], [113.0, 2963.0], [117.0, 2788.0], [118.0, 2034.0], [116.0, 2810.5], [123.0, 1828.0], [122.0, 2120.0], [120.0, 1054.0], [121.0, 136.0], [125.0, 4532.5], [124.0, 7792.0], [127.0, 1658.5], [126.0, 2325.5], [132.0, 2300.5], [130.0, 1901.5], [129.0, 4444.0], [131.0, 511.0], [128.0, 6405.5], [134.0, 9584.0], [133.0, 2982.0], [135.0, 636.5], [138.0, 694.5], [143.0, 1294.0], [139.0, 5393.0], [142.0, 12569.5], [141.0, 4261.5], [136.0, 4675.0], [140.0, 5560.0], [151.0, 802.0], [146.0, 897.0], [145.0, 3359.5], [150.0, 899.5], [148.0, 613.5], [149.0, 676.0], [144.0, 970.5], [147.0, 1998.0], [159.0, 1327.5], [157.0, 9448.0], [152.0, 1602.5], [155.0, 910.0], [154.0, 8167.0], [158.0, 2581.5], [153.0, 666.0], [162.0, 14323.5], [163.0, 5532.0], [171.0, 1022.0], [174.0, 8978.0], [168.0, 8798.0], [172.0, 12149.5], [177.0, 10677.0], [185.0, 13968.0], [197.0, 13493.0], [200.0, 12956.0], [211.0, 11639.0]], "isOverall": false, "label": "Successes", "isController": false}, {"data": [[32.0, 6.0], [69.0, 25.0], [42.0, 13.0], [23.0, 12.0], [56.0, 12.0], [29.0, 15.0]], "isOverall": false, "label": "Failures", "isController": false}], "supportsControllersDiscrimination": false, "granularity": 1000, "maxX": 211.0, "title": "Latencies Vs Request"}},
    getOptions: function() {
        return{
            series: {
                lines: {
                    show: false
                },
                points: {
                    show: true
                }
            },
            xaxis: {
                axisLabel: "Global number of requests per second",
                axisLabelUseCanvas: true,
                axisLabelFontSizePixels: 12,
                axisLabelFontFamily: 'Verdana, Arial',
                axisLabelPadding: 20,
            },
            yaxis: {
                axisLabel: "Median Latency in ms",
                axisLabelUseCanvas: true,
                axisLabelFontSizePixels: 12,
                axisLabelFontFamily: 'Verdana, Arial',
                axisLabelPadding: 20,
            },
            legend: { noColumns: 2,show: true, container: '#legendLatencyVsRequest' },
            selection: {
                mode: 'xy'
            },
            grid: {
                hoverable: true // IMPORTANT! this is needed for tooltip to work
            },
            tooltip: true,
            tooltipOpts: {
                content: "%s : Median Latency time at %x req/s was %y ms"
            },
            colors: ["#9ACD32", "#FF6347"]
        };
    },
    createGraph: function () {
        var data = this.data;
        var dataset = prepareData(data.result.series, $("#choicesLatencyVsRequest"));
        var options = this.getOptions();
        prepareOptions(options, data);
        $.plot($("#flotLatenciesVsRequest"), dataset, options);
        // setup overview
        $.plot($("#overviewLatenciesVsRequest"), dataset, prepareOverviewOptions(options));
    }
};

// Latencies vs Request
function refreshLatenciesVsRequest() {
        var infos = latenciesVsRequestInfos;
        prepareSeries(infos.data);
        if(isGraph($("#flotLatenciesVsRequest"))){
            infos.createGraph();
        }else{
            var choiceContainer = $("#choicesLatencyVsRequest");
            createLegend(choiceContainer, infos);
            infos.createGraph();
            setGraphZoomable("#flotLatenciesVsRequest", "#overviewLatenciesVsRequest");
            $('#footerLatenciesVsRequest .legendColorBox > div').each(function(i){
                $(this).clone().prependTo(choiceContainer.find("li").eq(i));
            });
        }
};

var hitsPerSecondInfos = {
        data: {"result": {"minY": 22.533333333333335, "minX": 1.6982169E12, "maxY": 121.93333333333334, "series": [{"data": [[1.69821714E12, 109.8], [1.69821696E12, 22.533333333333335], [1.69821702E12, 121.93333333333334], [1.6982172E12, 91.01666666666667], [1.6982169E12, 31.733333333333334], [1.69821726E12, 57.483333333333334], [1.69821708E12, 57.25]], "isOverall": false, "label": "hitsPerSecond", "isController": false}], "supportsControllersDiscrimination": false, "granularity": 60000, "maxX": 1.69821726E12, "title": "Hits Per Second"}},
        getOptions: function() {
            return {
                series: {
                    lines: {
                        show: true
                    },
                    points: {
                        show: true
                    }
                },
                xaxis: {
                    mode: "time",
                    timeformat: getTimeFormat(this.data.result.granularity),
                    axisLabel: getElapsedTimeLabel(this.data.result.granularity),
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                yaxis: {
                    axisLabel: "Number of hits / sec",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20
                },
                legend: {
                    noColumns: 2,
                    show: true,
                    container: "#legendHitsPerSecond"
                },
                selection: {
                    mode : 'xy'
                },
                grid: {
                    hoverable: true // IMPORTANT! this is needed for tooltip to
                                    // work
                },
                tooltip: true,
                tooltipOpts: {
                    content: "%s at %x was %y.2 hits/sec"
                }
            };
        },
        createGraph: function createGraph() {
            var data = this.data;
            var dataset = prepareData(data.result.series, $("#choicesHitsPerSecond"));
            var options = this.getOptions();
            prepareOptions(options, data);
            $.plot($("#flotHitsPerSecond"), dataset, options);
            // setup overview
            $.plot($("#overviewHitsPerSecond"), dataset, prepareOverviewOptions(options));
        }
};

// Hits per second
function refreshHitsPerSecond(fixTimestamps) {
    var infos = hitsPerSecondInfos;
    prepareSeries(infos.data);
    if(fixTimestamps) {
        fixTimeStamps(infos.data.result.series, 10800000);
    }
    if (isGraph($("#flotHitsPerSecond"))){
        infos.createGraph();
    }else{
        var choiceContainer = $("#choicesHitsPerSecond");
        createLegend(choiceContainer, infos);
        infos.createGraph();
        setGraphZoomable("#flotHitsPerSecond", "#overviewHitsPerSecond");
        $('#footerHitsPerSecond .legendColorBox > div').each(function(i){
            $(this).clone().prependTo(choiceContainer.find("li").eq(i));
        });
    }
}

var codesPerSecondInfos = {
        data: {"result": {"minY": 0.21666666666666667, "minX": 1.6982169E12, "maxY": 109.28333333333333, "series": [{"data": [[1.69821714E12, 109.28333333333333], [1.69821696E12, 38.983333333333334], [1.69821702E12, 105.26666666666667], [1.6982172E12, 82.23333333333333], [1.6982169E12, 15.066666666666666], [1.69821726E12, 74.15], [1.69821708E12, 66.55]], "isOverall": false, "label": "200", "isController": false}, {"data": [[1.69821696E12, 0.21666666666666667]], "isOverall": false, "label": "502", "isController": false}], "supportsControllersDiscrimination": false, "granularity": 60000, "maxX": 1.69821726E12, "title": "Codes Per Second"}},
        getOptions: function(){
            return {
                series: {
                    lines: {
                        show: true
                    },
                    points: {
                        show: true
                    }
                },
                xaxis: {
                    mode: "time",
                    timeformat: getTimeFormat(this.data.result.granularity),
                    axisLabel: getElapsedTimeLabel(this.data.result.granularity),
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                yaxis: {
                    axisLabel: "Number of responses / sec",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                legend: {
                    noColumns: 2,
                    show: true,
                    container: "#legendCodesPerSecond"
                },
                selection: {
                    mode: 'xy'
                },
                grid: {
                    hoverable: true // IMPORTANT! this is needed for tooltip to
                                    // work
                },
                tooltip: true,
                tooltipOpts: {
                    content: "Number of Response Codes %s at %x was %y.2 responses / sec"
                }
            };
        },
    createGraph: function() {
        var data = this.data;
        var dataset = prepareData(data.result.series, $("#choicesCodesPerSecond"));
        var options = this.getOptions();
        prepareOptions(options, data);
        $.plot($("#flotCodesPerSecond"), dataset, options);
        // setup overview
        $.plot($("#overviewCodesPerSecond"), dataset, prepareOverviewOptions(options));
    }
};

// Codes per second
function refreshCodesPerSecond(fixTimestamps) {
    var infos = codesPerSecondInfos;
    prepareSeries(infos.data);
    if(fixTimestamps) {
        fixTimeStamps(infos.data.result.series, 10800000);
    }
    if(isGraph($("#flotCodesPerSecond"))){
        infos.createGraph();
    }else{
        var choiceContainer = $("#choicesCodesPerSecond");
        createLegend(choiceContainer, infos);
        infos.createGraph();
        setGraphZoomable("#flotCodesPerSecond", "#overviewCodesPerSecond");
        $('#footerCodesPerSecond .legendColorBox > div').each(function(i){
            $(this).clone().prependTo(choiceContainer.find("li").eq(i));
        });
    }
};

var transactionsPerSecondInfos = {
        data: {"result": {"minY": 0.21666666666666667, "minX": 1.6982169E12, "maxY": 109.28333333333333, "series": [{"data": [[1.69821714E12, 109.28333333333333], [1.69821696E12, 38.983333333333334], [1.69821702E12, 105.26666666666667], [1.6982172E12, 82.23333333333333], [1.6982169E12, 15.066666666666666], [1.69821726E12, 74.15], [1.69821708E12, 66.55]], "isOverall": false, "label": "HTTP Request-success", "isController": false}, {"data": [[1.69821696E12, 0.21666666666666667]], "isOverall": false, "label": "HTTP Request-failure", "isController": false}], "supportsControllersDiscrimination": true, "granularity": 60000, "maxX": 1.69821726E12, "title": "Transactions Per Second"}},
        getOptions: function(){
            return {
                series: {
                    lines: {
                        show: true
                    },
                    points: {
                        show: true
                    }
                },
                xaxis: {
                    mode: "time",
                    timeformat: getTimeFormat(this.data.result.granularity),
                    axisLabel: getElapsedTimeLabel(this.data.result.granularity),
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                yaxis: {
                    axisLabel: "Number of transactions / sec",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20
                },
                legend: {
                    noColumns: 2,
                    show: true,
                    container: "#legendTransactionsPerSecond"
                },
                selection: {
                    mode: 'xy'
                },
                grid: {
                    hoverable: true // IMPORTANT! this is needed for tooltip to
                                    // work
                },
                tooltip: true,
                tooltipOpts: {
                    content: "%s at %x was %y transactions / sec"
                }
            };
        },
    createGraph: function () {
        var data = this.data;
        var dataset = prepareData(data.result.series, $("#choicesTransactionsPerSecond"));
        var options = this.getOptions();
        prepareOptions(options, data);
        $.plot($("#flotTransactionsPerSecond"), dataset, options);
        // setup overview
        $.plot($("#overviewTransactionsPerSecond"), dataset, prepareOverviewOptions(options));
    }
};

// Transactions per second
function refreshTransactionsPerSecond(fixTimestamps) {
    var infos = transactionsPerSecondInfos;
    prepareSeries(infos.data);
    if(infos.data.result.series.length == 0) {
        setEmptyGraph("#bodyTransactionsPerSecond");
        return;
    }
    if(fixTimestamps) {
        fixTimeStamps(infos.data.result.series, 10800000);
    }
    if(isGraph($("#flotTransactionsPerSecond"))){
        infos.createGraph();
    }else{
        var choiceContainer = $("#choicesTransactionsPerSecond");
        createLegend(choiceContainer, infos);
        infos.createGraph();
        setGraphZoomable("#flotTransactionsPerSecond", "#overviewTransactionsPerSecond");
        $('#footerTransactionsPerSecond .legendColorBox > div').each(function(i){
            $(this).clone().prependTo(choiceContainer.find("li").eq(i));
        });
    }
};

var totalTPSInfos = {
        data: {"result": {"minY": 0.21666666666666667, "minX": 1.6982169E12, "maxY": 109.28333333333333, "series": [{"data": [[1.69821714E12, 109.28333333333333], [1.69821696E12, 38.983333333333334], [1.69821702E12, 105.26666666666667], [1.6982172E12, 82.23333333333333], [1.6982169E12, 15.066666666666666], [1.69821726E12, 74.15], [1.69821708E12, 66.55]], "isOverall": false, "label": "Transaction-success", "isController": false}, {"data": [[1.69821696E12, 0.21666666666666667]], "isOverall": false, "label": "Transaction-failure", "isController": false}], "supportsControllersDiscrimination": true, "granularity": 60000, "maxX": 1.69821726E12, "title": "Total Transactions Per Second"}},
        getOptions: function(){
            return {
                series: {
                    lines: {
                        show: true
                    },
                    points: {
                        show: true
                    }
                },
                xaxis: {
                    mode: "time",
                    timeformat: getTimeFormat(this.data.result.granularity),
                    axisLabel: getElapsedTimeLabel(this.data.result.granularity),
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                yaxis: {
                    axisLabel: "Number of transactions / sec",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20
                },
                legend: {
                    noColumns: 2,
                    show: true,
                    container: "#legendTotalTPS"
                },
                selection: {
                    mode: 'xy'
                },
                grid: {
                    hoverable: true // IMPORTANT! this is needed for tooltip to
                                    // work
                },
                tooltip: true,
                tooltipOpts: {
                    content: "%s at %x was %y transactions / sec"
                },
                colors: ["#9ACD32", "#FF6347"]
            };
        },
    createGraph: function () {
        var data = this.data;
        var dataset = prepareData(data.result.series, $("#choicesTotalTPS"));
        var options = this.getOptions();
        prepareOptions(options, data);
        $.plot($("#flotTotalTPS"), dataset, options);
        // setup overview
        $.plot($("#overviewTotalTPS"), dataset, prepareOverviewOptions(options));
    }
};

// Total Transactions per second
function refreshTotalTPS(fixTimestamps) {
    var infos = totalTPSInfos;
    // We want to ignore seriesFilter
    prepareSeries(infos.data, false, true);
    if(fixTimestamps) {
        fixTimeStamps(infos.data.result.series, 10800000);
    }
    if(isGraph($("#flotTotalTPS"))){
        infos.createGraph();
    }else{
        var choiceContainer = $("#choicesTotalTPS");
        createLegend(choiceContainer, infos);
        infos.createGraph();
        setGraphZoomable("#flotTotalTPS", "#overviewTotalTPS");
        $('#footerTotalTPS .legendColorBox > div').each(function(i){
            $(this).clone().prependTo(choiceContainer.find("li").eq(i));
        });
    }
};

// Collapse the graph matching the specified DOM element depending the collapsed
// status
function collapse(elem, collapsed){
    if(collapsed){
        $(elem).parent().find(".fa-chevron-up").removeClass("fa-chevron-up").addClass("fa-chevron-down");
    } else {
        $(elem).parent().find(".fa-chevron-down").removeClass("fa-chevron-down").addClass("fa-chevron-up");
        if (elem.id == "bodyBytesThroughputOverTime") {
            if (isGraph($(elem).find('.flot-chart-content')) == false) {
                refreshBytesThroughputOverTime(true);
            }
            document.location.href="#bytesThroughputOverTime";
        } else if (elem.id == "bodyLatenciesOverTime") {
            if (isGraph($(elem).find('.flot-chart-content')) == false) {
                refreshLatenciesOverTime(true);
            }
            document.location.href="#latenciesOverTime";
        } else if (elem.id == "bodyCustomGraph") {
            if (isGraph($(elem).find('.flot-chart-content')) == false) {
                refreshCustomGraph(true);
            }
            document.location.href="#responseCustomGraph";
        } else if (elem.id == "bodyConnectTimeOverTime") {
            if (isGraph($(elem).find('.flot-chart-content')) == false) {
                refreshConnectTimeOverTime(true);
            }
            document.location.href="#connectTimeOverTime";
        } else if (elem.id == "bodyResponseTimePercentilesOverTime") {
            if (isGraph($(elem).find('.flot-chart-content')) == false) {
                refreshResponseTimePercentilesOverTime(true);
            }
            document.location.href="#responseTimePercentilesOverTime";
        } else if (elem.id == "bodyResponseTimeDistribution") {
            if (isGraph($(elem).find('.flot-chart-content')) == false) {
                refreshResponseTimeDistribution();
            }
            document.location.href="#responseTimeDistribution" ;
        } else if (elem.id == "bodySyntheticResponseTimeDistribution") {
            if (isGraph($(elem).find('.flot-chart-content')) == false) {
                refreshSyntheticResponseTimeDistribution();
            }
            document.location.href="#syntheticResponseTimeDistribution" ;
        } else if (elem.id == "bodyActiveThreadsOverTime") {
            if (isGraph($(elem).find('.flot-chart-content')) == false) {
                refreshActiveThreadsOverTime(true);
            }
            document.location.href="#activeThreadsOverTime";
        } else if (elem.id == "bodyTimeVsThreads") {
            if (isGraph($(elem).find('.flot-chart-content')) == false) {
                refreshTimeVsThreads();
            }
            document.location.href="#timeVsThreads" ;
        } else if (elem.id == "bodyCodesPerSecond") {
            if (isGraph($(elem).find('.flot-chart-content')) == false) {
                refreshCodesPerSecond(true);
            }
            document.location.href="#codesPerSecond";
        } else if (elem.id == "bodyTransactionsPerSecond") {
            if (isGraph($(elem).find('.flot-chart-content')) == false) {
                refreshTransactionsPerSecond(true);
            }
            document.location.href="#transactionsPerSecond";
        } else if (elem.id == "bodyTotalTPS") {
            if (isGraph($(elem).find('.flot-chart-content')) == false) {
                refreshTotalTPS(true);
            }
            document.location.href="#totalTPS";
        } else if (elem.id == "bodyResponseTimeVsRequest") {
            if (isGraph($(elem).find('.flot-chart-content')) == false) {
                refreshResponseTimeVsRequest();
            }
            document.location.href="#responseTimeVsRequest";
        } else if (elem.id == "bodyLatenciesVsRequest") {
            if (isGraph($(elem).find('.flot-chart-content')) == false) {
                refreshLatenciesVsRequest();
            }
            document.location.href="#latencyVsRequest";
        }
    }
}

/*
 * Activates or deactivates all series of the specified graph (represented by id parameter)
 * depending on checked argument.
 */
function toggleAll(id, checked){
    var placeholder = document.getElementById(id);

    var cases = $(placeholder).find(':checkbox');
    cases.prop('checked', checked);
    $(cases).parent().children().children().toggleClass("legend-disabled", !checked);

    var choiceContainer;
    if ( id == "choicesBytesThroughputOverTime"){
        choiceContainer = $("#choicesBytesThroughputOverTime");
        refreshBytesThroughputOverTime(false);
    } else if(id == "choicesResponseTimesOverTime"){
        choiceContainer = $("#choicesResponseTimesOverTime");
        refreshResponseTimeOverTime(false);
    }else if(id == "choicesResponseCustomGraph"){
        choiceContainer = $("#choicesResponseCustomGraph");
        refreshCustomGraph(false);
    } else if ( id == "choicesLatenciesOverTime"){
        choiceContainer = $("#choicesLatenciesOverTime");
        refreshLatenciesOverTime(false);
    } else if ( id == "choicesConnectTimeOverTime"){
        choiceContainer = $("#choicesConnectTimeOverTime");
        refreshConnectTimeOverTime(false);
    } else if ( id == "choicesResponseTimePercentilesOverTime"){
        choiceContainer = $("#choicesResponseTimePercentilesOverTime");
        refreshResponseTimePercentilesOverTime(false);
    } else if ( id == "choicesResponseTimePercentiles"){
        choiceContainer = $("#choicesResponseTimePercentiles");
        refreshResponseTimePercentiles();
    } else if(id == "choicesActiveThreadsOverTime"){
        choiceContainer = $("#choicesActiveThreadsOverTime");
        refreshActiveThreadsOverTime(false);
    } else if ( id == "choicesTimeVsThreads"){
        choiceContainer = $("#choicesTimeVsThreads");
        refreshTimeVsThreads();
    } else if ( id == "choicesSyntheticResponseTimeDistribution"){
        choiceContainer = $("#choicesSyntheticResponseTimeDistribution");
        refreshSyntheticResponseTimeDistribution();
    } else if ( id == "choicesResponseTimeDistribution"){
        choiceContainer = $("#choicesResponseTimeDistribution");
        refreshResponseTimeDistribution();
    } else if ( id == "choicesHitsPerSecond"){
        choiceContainer = $("#choicesHitsPerSecond");
        refreshHitsPerSecond(false);
    } else if(id == "choicesCodesPerSecond"){
        choiceContainer = $("#choicesCodesPerSecond");
        refreshCodesPerSecond(false);
    } else if ( id == "choicesTransactionsPerSecond"){
        choiceContainer = $("#choicesTransactionsPerSecond");
        refreshTransactionsPerSecond(false);
    } else if ( id == "choicesTotalTPS"){
        choiceContainer = $("#choicesTotalTPS");
        refreshTotalTPS(false);
    } else if ( id == "choicesResponseTimeVsRequest"){
        choiceContainer = $("#choicesResponseTimeVsRequest");
        refreshResponseTimeVsRequest();
    } else if ( id == "choicesLatencyVsRequest"){
        choiceContainer = $("#choicesLatencyVsRequest");
        refreshLatenciesVsRequest();
    }
    var color = checked ? "black" : "#818181";
    if(choiceContainer != null) {
        choiceContainer.find("label").each(function(){
            this.style.color = color;
        });
    }
}

